
% Clear MATLAB
clc
clear all
close all

% load apm libraries
addpath('apm');

% model and data files
model_file = 'ethyl.apm';
data_file = 'Reduced.csv';

% assign server and application names
server = 'http://xps.apmonitor.com';

app = 'dynamic_estimate';

% clear previous application
apm(server,app,'clear all');

% load model variables and equation
apm_load(server,app,model_file);
csv_load(server,app,data_file);

% parameters to fit model
apm_info(server,app,'FV','Ea1');
apm_info(server,app,'FV','Ea2');
apm_info(server,app,'FV','A1');
apm_info(server,app,'FV','A2');
apm_info(server,app,'FV','alpha');
apm_info(server,app,'FV','beta');
apm_info(server,app,'FV','kappa');
apm_info(server,app,'FV','delta');

% State variables, not measured
apm_info(server,app,'SV','NaAc');
apm_info(server,app,'SV','EtOH');
apm_info(server,app,'SV','EtAc');

% controlled and measured variables
apm_info(server,app,'CV','OH');

% options
apm_option(server,app,'nlc.imode',5);
apm_option(server,app,'nlc.solver',1);
apm_option(server,app,'nlc.max_iter',200);
apm_option(server,app,'nlc.ev_type',2);
% adjust measurement gap to acount for noise
apm_option(server,app,'OH.meas_gap',0.001);
apm_option(server,app,'OH.wmeas',1000);

% turn off default time-shift for dyanamic problems
apm_option(server,app,'nlc.time_shift',0);

% initialize problem
apm_option(server,app,'nlc.coldstart',1);
output = apm(server,app,'solve');
disp(output)

% solve for parameters
apm_option(server,app,'Ea1.status',1);
apm_option(server,app,'A1.status',1);

% display some results
disp(['Ea1: ' num2str(apm_tag(server,app,'ea1.newval'))])
disp(['A1: ' num2str(apm_tag(server,app,'a1.newval'))])

%solve
apm(server,app,'solve')

% turn on parameter estimation
apm_option(server,app,'Ea2.status',1);
apm_option(server,app,'A2.status',1);

%solve again
output = apm(server,app,'solve');
disp(output)

% display results
disp(['Ea1: ' num2str(apm_tag(server,app,'ea1.newval'))])
disp(['A1: ' num2str(apm_tag(server,app,'a1.newval'))])
disp(['Ea2: ' num2str(apm_tag(server,app,'ea2.newval'))])
disp(['A2: ' num2str(apm_tag(server,app,'a2.newval'))])

% change this to true to estimate alpha and beta
if false,
    % solve for alpha and beta
	apm_option(server,app,'alpha.status',1);
	apm_option(server,app,'beta.status',1);
	apm_option(server,app,'kappa.status',1);
	apm_option(server,app,'delta.status',1);
	apm(server,app,'solve')
end

% retrieve results
solution = apm_sol(server,app);

% open web viewer
apm_web(server,app);

% extract values
z = solution.x;

% Retrieve measurements from data file
data = csv_data(data_file);
[nrow,ncol] = size(data);
% retrieve time
icol = csv_lookup('time',data);
for i = 2:nrow,
    time_meas(i-1) = str2num(data{i,icol});
end
% retrieve EtAc concentration
icol = csv_lookup('EtAc',data);
for i = 2:nrow,
    EtAc_meas(i-1) = str2num(data{i,icol});
end
% retrieve OH concentration
icol = csv_lookup('OH',data);
for i = 2:nrow,
    oh_meas(i-1) = str2num(data{i,icol});
end

figure(1)

subplot(3,1,1)
plot(z.time/60,z.oh,'k-')
hold on
plot(time_meas/60,oh_meas,'r.')
legend('[OH^-]_{model}','[OH^-]_{meas}')
ylabel('[OH^-]')

subplot(3,1,2)
plot(z.time/60,z.etac,'g-')
legend('Ethyl Acetate')
ylabel('[EtAc]')

subplot(3,1,3)
plot(z.time/60,z.tc,'b-')
ylabel('Temp (degC)')
legend('Temperature')
xlabel('Time (min)')