from apm import *
import matplotlib
import numpy as np
import matplotlib.pyplot as plt

# Select server
s = 'http://byu.apmonitor.com'

# Give the application a name
a = 'etac_python'

# model and data files
model_file = 'etac.apm'
data_file = 'etac.csv'

# Clear the s
apm(s,a,'clear all')

# Load model variables and equations
apm_load(s,a,model_file)
# Load data
csv_load(s,a,data_file)

# Parameters to fit model
apm_info(s,a,'FV', 'Ea1')
apm_info(s,a,'FV', 'A1')
apm_info(s,a,'FV', 'alpha')
apm_info(s,a,'FV', 'beta')
apm_info(s,a,'MV', 'T')
apm_info(s,a,'MV', 'EtAc')
# Measured / Controlled variable (OH)
apm_info(s,a,'CV', 'OH')

# Overall options
apm_option(s,a,'nlc.imode',5)
apm_option(s,a,'nlc.ev_type',2)
apm_option(s,a,'nlc.solver',1)
apm_option(s,a,'nlc.max_iter',200)
# Adjust measurement gap to account for noise
apm_option(s,a,'OH.meas_gap',0.000)
apm_option(s,a,'OH.wmeas',1000)

# Initialize problem
apm_option(s,a,'nlc.coldstart',1)
apm(s,a,'solve')

# Solve for parameters
apm_option(s,a,'A1.status',1)
apm_option(s,a,'Ea1.status',1)

# Solve
output = apm(s,a,'solve')
print (output)

# Change this to True to estimate alpha and beta
if False:
    # solve for alpha and beta
    apm_option(s,a,'alpha.status',1)
    apm_option(s,a,'beta.status',1)
    apm(s,a,'solve')

# Open web viewer
apm_web(s,a)

# Retrieve results
solution = apm_sol(s,a)

# Extract results
#n = len(sol['time'])
#time = np.empty(n)
#temp = np.empty(n)
#etac = np.empty(n)
#for i in range(0,n):
#  time[i] = sol['time'][i] / 60.0
#  temp[i] = sol['tk'][i] - 273.15
#  etac[i] = sol['c_etac'][i]

# Read measured values
data = csv_data(data_file)
#m = len(data['time'])
#data_time = np.empty(m)
#data_etac = np.empty(m)
#for i in range(0,m):
#  data_time[i] = data['time'][i] / 60.0
#  data_etac[i] = data['c_EtAc'][i]
  
# Display results
plt.figure

plt.subplot(311)
plt.plot(sol['time'],sol['oh'],'k-')
plt.plot(data['time'],data['oh'],'r-')
plt.legend(['OH model','OH meas'])
plt.ylabel('Conc OH-')

plt.subplot(312)
plt.plot(sol['time'],sol['etac'],'k-')
plt.plot(data['time'],data['etac'],'r-')
plt.legend(['EtAc model','EtAc meas'])
plt.ylabel('Conc EtAc')

plt.subplot(313)
plt.plot(sol['time'],sol['t'],'b-')
plt.legend(['Temperature'])
plt.ylabel('T (Kelvin)')
plt.xlabel('Time (min)')

plt.show()

