%clear everythign
clc; clear all; close all

%load apm lib
addpath('apm')

% model and data files
model_file = 'etac.apm';
data_file = 'etac.csv';

%define server and app
server = 'http://xps.apmonitor.com';
app = 'dynamic_estimate';

%clear the server
apm(server,app,'clear all');

%load model variables and equations
apm_load(server,app,model_file);
%load data
csv_load(server,app,data_file);

%Parameters to fit model
apm_info(server,app,'FV', 'Ea1');
apm_info(server,app,'FV', 'A1');
apm_info(server,app,'FV', 'alpha');
apm_info(server,app,'FV', 'beta');
apm_info(server,app,'MV', 'T');
apm_info(server,app,'MV', 'EtAc');
%controlled variable (oh)
apm_info(server,app,'CV', 'OH');

%overall options
apm_option(server,app,'nlc.imode',5);
apm_option(server,app,'nlc.ev_type',2);
apm_option(server,app,'nlc.solver',1);
apm_option(server,app,'nlc.max_iter',200);
%adjust measurement gap to account for noise
apm_option(server,app,'OH.meas_gap',0.000);
apm_option(server,app,'OH.wmeas',1000);

% initialize problem
apm_option(server,app,'nlc.coldstart',1);
apm(server,app,'solve')

% solve for parameters
apm_option(server,app,'A1.status',1);
apm_option(server,app,'Ea1.status',1);

%solve
apm(server,app,'solve')

% change this to true to estimate alpha and beta
if false,
    % solve for alpha and beta
    apm_option(server,app,'alpha.status',1);
    apm_option(server,app,'beta.status',1);
    apm(server,app,'solve')
end

%retrive results
solution = apm_sol(server,app);
%open web viewer
apm_web(server,app);

% extract values
z = solution.x;

% Retrieve measurements from data file
data = csv_data(data_file);
[nrow,ncol] = size(data);
% retrieve time
icol = csv_lookup('time',data);
for i = 2:nrow,
    time_meas(i-1) = str2num(data{i,icol});
end
% retrieve EtAc concentration
icol = csv_lookup('EtAc',data);
for i = 2:nrow,
    EtAc_meas(i-1) = str2num(data{i,icol});
end
% retrieve OH concentration
icol = csv_lookup('OH',data);
for i = 2:nrow,
    oh_meas(i-1) = str2num(data{i,icol});
end

figure(1)

subplot(3,1,1)
plot(z.time,z.oh,'k-')
hold on
plot(time_meas,oh_meas,'r.')
legend('[OH^-]_{model}','[OH^-]_{meas}')
ylabel('[OH^-]')

subplot(3,1,2)
plot(z.time,z.etac,'g-')
legend('Ethyl Acetate')
ylabel('[EtAc]')

subplot(3,1,3)
plot(z.time,z.t-273.15,'b-')
ylabel('Temp (degC)')
legend('Temperature')
xlabel('Time (min)')

