from apm import *
import matplotlib
import numpy as np
import matplotlib.pyplot as plt

# Select server
s = 'http://byu.apmonitor.com'

# alication name
a = 'ethyl_acetate'
model_file = 'EtAc.apm'
data_file = 'data.csv'

# Clear previous alication
apm(s,a,'clear all')

# Load model file
apm_load(s,a,model_file)

# Load data file
csv_load(s,a,data_file)

# Option to select solver (1=APOPT, 2=BPOPT, 3=IPOPT)
apm_option(s,a,'nlc.solver',1)
apm_option(s,a,'nlc.max_iter',400)

# Classify parameters and variables
apm_info(s,a,'FV','A')
apm_info(s,a,'FV','Ea')
apm_info(s,a,'FV','alpha')
apm_info(s,a,'FV','beta')
apm_info(s,a,'MV','Tk')
apm_info(s,a,'MV','c_OH')
apm_info(s,a,'CV','c_EtAc')

# Options
apm_option(s,a,'nlc.csv_read',1)
apm_option(s,a,'nlc.ev_type',1)
apm_option(s,a,'nlc.imode',5)

# Initialize Data reconciliation
apm_option(s,a,'nlc.coldstart',1)
apm(s,a,'solve')

apm_option(s,a,'A.status',1)
apm_option(s,a,'Ea.status',1)

# Estimate reaction orders
estimate_orders = False
if estimate_orders:
  apm_option(s,a,'alpha.status',1)
  apm_option(s,a,'beta.status',1)
else:
  apm_option(s,a,'alpha.status',0)
  apm_option(s,a,'beta.status',0)

apm_option(s,a,'c_EtAc.fstatus',1)
apm_option(s,a,'c_EtAc.wmeas',100)

# Turn up Diagnostic Level for bounding box generation
apm_option(s,a,'nlc.diaglevel',0)

# Solve Data reconciliation
apm(s,a,'solve')

# Display Results in Web Viewer 
url = apm_web(s,a)

# Retrieve results
sol = apm_sol(s,a)

# Extract results
n = len(sol['time'])
time = np.empty(n)
temp = np.empty(n)
etac = np.empty(n)
for i in range(0,n):
  time[i] = sol['time'][i] / 60.0
  temp[i] = sol['tk'][i] - 273.15
  etac[i] = sol['c_etac'][i]

# Read measured values
data = csv_data('data.csv')
m = len(data['time'])
data_time = np.empty(m)
data_etac = np.empty(m)
for i in range(0,m):
  data_time[i] = data['time'][i] / 60.0
  data_etac[i] = data['c_EtAc'][i]
  
# Display results
plt.figure()

plt.subplot(211)
plt.plot(time,etac,'k-')
plt.plot(data_time,data_etac,'r-')
plt.legend(['EtAc model','EtAc meas'])
plt.ylabel('Conc EtAc')

plt.subplot(212)
plt.plot(time,temp,'b-')
plt.legend(['Temperature'])
plt.ylabel('T (degC)')
plt.xlabel('Time (min)')

plt.show()
