## problem configuration
# number of cycles
cycles = 100
# noise level
noise = 0.5
# change process order to 1, 2, or 10 in process.apm
#  Constants
#    ! process model order
#    n = 1  <------------------ Change this number in process.apm

## load APMonitor
from apm import *
# select server
s = 'http://byu.apmonitor.com'

## process simulator
from random import randint
a1 = 'process' + str(randint(1,1000))
apm(s,a1,'clear all')
apm_load(s,a1,'process.apm')
csv_load(s,a1,'process.csv')
apm_option(s,a1,'apm.imode',5)
apm_info(s,a1,'MV','u')
apm_info(s,a1,'SV','y')

## estimator
a2 = 'estimator' + str(randint(1,1000))
apm(s,a2,'clear all')
# load model and data file (time horizon)
apm_load(s,a2,'model.apm')
csv_load(s,a2,'model.csv')
# application settings
apm_option(s,a2,'apm.imode',5)
apm_option(s,a2,'apm.diaglevel',0)
apm_option(s,a2,'apm.solver',3)
apm_option(s,a2,'apm.web_plot_freq',1)
# FV = fixed value, parameter same over time horizon
# MV = manipulated variable with possibly different values over time horizon
# SV = state variable (unmeasured states)
# CV = controlled variable (measured states)
apm_info(s,a2,'FV','tau')
apm_info(s,a2,'FV','K')
apm_info(s,a2,'MV','u')
apm_info(s,a2,'SV','x')
apm_info(s,a2,'CV','y')
# STATUS = 0, optimizer doesn't adjust value
# STATUS = 1, optimizer can adjust
apm_option(s,a2,'u.status',0)
apm_option(s,a2,'k.status',1)
apm_option(s,a2,'tau.status',1)
# FSTATUS = 0, no measurement
# FSTATUS = 1, measurement used to update model
apm_option(s,a2,'u.fstatus',1)
apm_option(s,a2,'k.fstatus',0)
apm_option(s,a2,'tau.fstatus',0)
apm_option(s,a2,'y.fstatus',1)
# DMAX = maximum movement each cycle
apm_option(s,a2,'k.dmax',1)
apm_option(s,a2,'tau.dmax',0.1)
# DCOST = penalize parameter movement
apm_option(s,a2,'k.dcost',1)
apm_option(s,a2,'tau.dcost',0)
# MEAS_GAP = dead-band for measurement / model mismatch
apm_option(s,a2,'y.meas_gap',0.5)

# values of u change randomly over time every 10th step
import numpy as np
from random import random
u_meas = np.zeros(cycles)
step_u = 0
for i in range(0,cycles):
    if (i % 10) == 0:
        # random step (-5 to 5)
        step_u = step_u + (random()-0.5)*10
    u_meas[i] = step_u

# run process and estimator for cycles
y_meas = np.empty(cycles)
y_est = np.empty(cycles)
k_est = np.empty(cycles)
tau_est = np.empty(cycles)
for i in range(1,cycles):
    # process simulator
    apm_meas(s,a1,'u',u_meas[i])
    output = apm(s,a1,'solve')
    y_meas[i] = apm_tag(s,a1,'y.model') + (random()-0.5)*noise
    
    # estimator
    apm_meas(s,a2,'u',u_meas[i])
    apm_meas(s,a2,'y',y_meas[i])
    output = apm(s,a2,'solve')
    print (output)
    y_est[i] = apm_tag(s,a2,'y.model')
    k_est[i] = apm_tag(s,a2,'k.newval')
    tau_est[i] = apm_tag(s,a2,'tau.newval')
    
    # open web-viewer on first cycle
    if i==1:
        apm_web(s,a2)

