from apm import * # load APMonitor.com  toolkit

# s = server, a = application
s = 'http://byu.apmonitor.com'
a = 'velocity'

# clear prior application
apm(s,a,'clear all')

# load model and data
apm_load(s,a,'ferrari.apm')
csv_load(s,a,'ferrari.csv')

# specify parameters
apm_info(s,a,'FV','K')
apm_info(s,a,'FV','b')
apm_info(s,a,'CV','v')

# turn on measurement objective and parameter status
apm_option(s,a,'v.fstatus',1)
apm_option(s,a,'K.status',1)
apm_option(s,a,'b.status',1)

# bounds on parameter
apm_option(s,a,'b.lower',1e-5)
apm_option(s,a,'b.upper',100)

# configuration parameters
apm_option(s,a,'nlc.imode',5)
apm_option(s,a,'nlc.nodes',3)

# solve and retrieve results
output = apm(s,a,'solve')
print(output)
y = apm_sol(s,a)

print('')
print('Solution: ')
print('K: ' + str(y['k'][0]))
print('b: ' + str(y['b'][0]))

# open web-viewer
apm_web(s,a)
