clear all; close all; clc % clear session
addpath('apm') % load APMonitor.com  toolkit

% s = server, a = application
s = 'http://byu.apmonitor.com';
a = 'velocity';

% clear prior application
apm(s,a,'clear all');

% load model and data
apm_load(s,a,'ferrari.apm');
csv_load(s,a,'ferrari.csv');

% specify parameters
apm_info(s,a,'FV','K');
apm_info(s,a,'FV','b');
apm_info(s,a,'CV','v');

% turn on measurement objective and parameter status
apm_option(s,a,'v.fstatus',1);
apm_option(s,a,'K.status',1);
apm_option(s,a,'b.status',1);

% bounds on parameter
apm_option(s,a,'b.lower',1e-5);
apm_option(s,a,'b.upper',100);

% configuration parameters
apm_option(s,a,'nlc.imode',5);
apm_option(s,a,'nlc.nodes',3);

% solve and retrieve results
output = apm(s,a,'solve'); disp(output);
y = apm_sol(s,a); z = y.x; 

% open web-viewer
apm_web(s,a);

% data
data = [0,0
1,0
2,0
3,0
5,18.12692469
8,39.34693403
12,59.34303403
17,75.34030361
23,86.46647168
30,93.27944873
38,96.98026166
48,98.88910035
60,99.66540345];

t_meas = data(:,1);
v_meas = data(:,2);

% plot results
figure(1)

subplot(2,1,1)
plot(z.time,z.p,'k-','LineWidth',2)
legend('Pedal')
ylabel('Position (%)')
axis([0 60 -5 105])
text(10,60,'Actual Parameters')
text(10,45,'K = 1.0')
text(10,30,'b = 50.0')
text(30,60,'Optimized Parameters')
text(30,45,['K = ' num2str(z.k(1))])
text(30,30,['b = ' num2str(z.b(1))])

subplot(2,1,2)
plot(t_meas,v_meas,'r-','LineWidth',3)
hold on
plot(z.time,z.v,'b.-','LineWidth',2)
axis([0 60 -5 105])
legend('Measured','Predicted')
ylabel('Velocity (m/s)')
xlabel('Time (sec)')