function p = est_apm(u)

persistent s a icount

if (isempty(icount)),
    % -------------------------------------------
    % Setting up APMonitor
    % For any tutorials see 
    % http://apmonitor.com/wiki/index.php/Main/MATLAB
    % -------------------------------------------
    
    % Add path to APM libraries
    addpath('apm');
    
    % Select server and application name
    s = 'http://byu.apmonitor.com';
    a = 'ferrari';
    
    % Clear previous application
    apm(s,a,'clear all');
    
    % load model variables and equations
    apm_load(s,a,'ferrari.apm');
    
    % load data
    csv_load(s,a,'ferrari10.csv');
    
    %  APM Variable Classification
    apm_info(s,a,'FV','k');
    apm_info(s,a,'FV','b');
    apm_info(s,a,'SV','tau');
    apm_info(s,a,'MV','p');
    apm_info(s,a,'CV','v');
    
    % Options
    apm_option(s,a,'nlc.imode',5);
    apm_option(s,a,'nlc.nodes',3);
    % Bounds on parameters
    apm_option(s,a,'k.lower',0.5);
    apm_option(s,a,'k.upper',2);
    apm_option(s,a,'tau.lower',5);
    apm_option(s,a,'tau.upper',30);
    apm_option(s,a,'v.meas_gap',2);
    % Turn on parameters to estimate
    apm_option(s,a,'k.status',1);
    apm_option(s,a,'b.status',1);
    apm_option(s,a,'k.fstatus',0);
    apm_option(s,a,'b.fstatus',0);
    % Turn on states to reconcile
    apm_option(s,a,'v.fstatus',1);
    
    % Initialize counter
    icount = 0;
end

icount = icount + 1;

% Input measurements
apm_meas(s,a,'v',u(1));
apm_meas(s,a,'p',u(2));

% Solve
output = apm(s,a,'solve');

% Output parameters
p(1) = apm_tag(s,a,'k.newval');
p(2) = apm_tag(s,a,'tau.model');

disp(['Count: ' int2str(icount) ', K: ' int2str(p(1)) ', tau: ' num2str(p(2))])

if (icount==30),
    % open web-viewer
    apm_web(s,a);
end

end
