from apm import *

# server and application name
server = 'http://byu.apmonitor.com'
app = 'virus'

# Clear previous application
apm(server,app,'clear all')

# load model variables and equations
apm_load(server,app,'hiv.apm')

# load csv file
csv_load(server,app,'hiv.csv')

# Set up variable classifications for data flow

# State variables (for display only)
apm_info(server,app,'F','lg10_kr1')
apm_info(server,app,'F','lg10_kr2')
apm_info(server,app,'F','lg10_kr3')
apm_info(server,app,'F','lg10_kr4')
apm_info(server,app,'F','lg10_kr5')
apm_info(server,app,'F','lg10_kr6')
apm_info(server,app,'S','H')
apm_info(server,app,'S','I')
apm_info(server,app,'S','V')
apm_info(server,app,'C','LV')

# imode = 7, switch to dynamic simulation
apm_option(server,app,'nlc.imode',5)
# nodes = 3, internal nodes in the collocation structure (2-6)
apm_option(server,app,'nlc.nodes',3)
# coldstart application (1=sec, 2=min, 3=hr, 4=day, 5=yr)
apm_option(server,app,'nlc.ctrl_units',5)
apm_option(server,app,'nlc.solver',1)
apm_option(server,app,'nlc.ev_type',2)
apm_option(server,app,'nlc.time_shift',0)
apm_option(server,app,'nlc.max_iter',100)
apm_option(server,app,'nlc.imode',5)
apm_option(server,app,'nlc.coldstart',2)
apm_option(server,app,'nlc.sensitivity',0)

# initialize
apm(server,app,'solve')

# turn on parameter estimate
apm_option(server,app,'lg10_kr1.status',1)
apm_option(server,app,'lg10_kr1.dmax',2)
apm_option(server,app,'lg10_kr1.lower',-10)
apm_option(server,app,'lg10_kr1.upper',10)

apm_option(server,app,'lg10_kr2.status',1)
apm_option(server,app,'lg10_kr2.dmax',2)
apm_option(server,app,'lg10_kr2.lower',-10)
apm_option(server,app,'lg10_kr2.upper',10)

apm_option(server,app,'lg10_kr3.status',1)
apm_option(server,app,'lg10_kr3.dmax',2)
apm_option(server,app,'lg10_kr3.lower',-10)
apm_option(server,app,'lg10_kr3.upper',10)

apm_option(server,app,'lg10_kr4.status',1)
apm_option(server,app,'lg10_kr4.dmax',2)
apm_option(server,app,'lg10_kr4.lower',-10)
apm_option(server,app,'lg10_kr4.upper',10)

apm_option(server,app,'lg10_kr5.status',1)
apm_option(server,app,'lg10_kr5.dmax',2)
apm_option(server,app,'lg10_kr5.lower',-10)
apm_option(server,app,'lg10_kr5.upper',10)

apm_option(server,app,'lg10_kr6.status',0)
apm_option(server,app,'lg10_kr6.dmax',2)
apm_option(server,app,'lg10_kr6.lower',-10)
apm_option(server,app,'lg10_kr6.upper',10)

apm_option(server,app,'lv.fstatus',1)

# solve a second time with DOF ON
apm_option(server,app,'nlc.coldstart',0)
apm_option(server,app,'nlc.time_shift',0)
apm_option(server,app,'nlc.sensitivity',1)
apm(server,app,'solve')

apm_web(server,app)

y = apm_sol(server,app)

# load data file for comparison
import numpy as np
data = np.genfromtxt('hiv_data.csv', delimiter=',')
# convert log-scaled data for plotting
log_v = data[:,][:,1] # 2nd column of data
v = np.power(10,log_v)

# plot results
import matplotlib.pyplot as plt
plt.figure(1)
plt.semilogy(y['time'],y['h'],'b-')
plt.semilogy(y['time'],y['i'],'g:')
plt.semilogy(y['time'],y['v'],'r--')
plt.semilogy(data[:,][:,0],v,'ro')
plt.xlabel('Time (yr)')
plt.ylabel('States (log scale)')
plt.legend(['H','I','V']) #,'V data')
plt.show()
