% Clear MATLAB
clear all
close all
clc

addpath('apm');

server = 'http://byu.apmonitor.com';
%server = 'http://localhost';

app = 'virus';

% Clear previous application
apm(server,app,'clear all');

% Simulate with MATLAB
time = 0:0.25:15;
%time = 0:0.25:4;
X = [1e6 0 1e2 2];
[t_ode15s,y] = ode15s('virus_model',time,X(1,1:3));

% add some measurement noise to the virus
log10_ym = log10(y(:,3));
randn('seed',-1)
log10_ym = log10_ym + randn(size(log10_ym))*0.5;
ym = 10.^log10_ym;

% load model variables and equations
apm_load(server,app,'hiv.apm');

% load csv file
csv_load(server,app,'hiv.csv');

% Set up variable classifications for data flow

% State variables (for display only)
apm_info(server,app,'F','lg10_kr1');
apm_info(server,app,'F','lg10_kr2');
apm_info(server,app,'F','lg10_kr3');
apm_info(server,app,'F','lg10_kr4');
apm_info(server,app,'F','lg10_kr5');
apm_info(server,app,'F','lg10_kr6');
apm_info(server,app,'S','H');
apm_info(server,app,'S','I');
apm_info(server,app,'S','V');
apm_info(server,app,'C','LV');

% imode = 7, switch to dynamic simulation
apm_option(server,app,'nlc.imode',5);
% nodes = 3, internal nodes in the collocation structure (2-6)
apm_option(server,app,'nlc.nodes',3);
% coldstart application (1=sec, 2=min, 3=hr, 4=day, 5=yr)
apm_option(server,app,'nlc.ctrl_units',5);
apm_option(server,app,'nlc.solver',1);
apm_option(server,app,'nlc.ev_type',2);
apm_option(server,app,'nlc.time_shift',0);
apm_option(server,app,'nlc.max_iter',100);
apm_option(server,app,'nlc.imode',5);
apm_option(server,app,'nlc.coldstart',2);
apm_option(server,app,'nlc.sensitivity',0);

% initialize
apm(server,app,'solve')

% turn on parameter estimate
apm_option(server,app,'lg10_kr1.status',1);
apm_option(server,app,'lg10_kr1.dmax',2);
apm_option(server,app,'lg10_kr1.lower',-10);
apm_option(server,app,'lg10_kr1.upper',10);

apm_option(server,app,'lg10_kr2.status',1);
apm_option(server,app,'lg10_kr2.dmax',2);
apm_option(server,app,'lg10_kr2.lower',-10);
apm_option(server,app,'lg10_kr2.upper',10);

apm_option(server,app,'lg10_kr3.status',1);
apm_option(server,app,'lg10_kr3.dmax',2);
apm_option(server,app,'lg10_kr3.lower',-10);
apm_option(server,app,'lg10_kr3.upper',10);

apm_option(server,app,'lg10_kr4.status',0);
apm_option(server,app,'lg10_kr4.dmax',2);
apm_option(server,app,'lg10_kr4.lower',-10);
apm_option(server,app,'lg10_kr4.upper',10);

apm_option(server,app,'lg10_kr5.status',0);
apm_option(server,app,'lg10_kr5.dmax',2);
apm_option(server,app,'lg10_kr5.lower',-10);
apm_option(server,app,'lg10_kr5.upper',10);

apm_option(server,app,'lg10_kr6.status',0);
apm_option(server,app,'lg10_kr6.dmax',2);
apm_option(server,app,'lg10_kr6.lower',-10);
apm_option(server,app,'lg10_kr6.upper',10);

apm_option(server,app,'lv.fstatus',1);

% solve a second time with DOF ON
apm_option(server,app,'nlc.time_shift',0);
apm_option(server,app,'nlc.sensitivity',1);
apm(server,app,'solve')

apm_web(server,app);

sol = apm_sol(server,app);
tp = sol.x.time;
h = sol.x.h;
i = sol.x.i;
v = sol.x.v;

% plot results
figure(1);
semilogy(tp,h,'b-')
hold on
semilogy(tp,i,'g-')
semilogy(tp,v,'r-')
semilogy(t_ode15s,y,'.')
semilogy(time,ym,'rx','MarkerSize',5)
xlabel('Time (yr)')
ylabel('Count')
legend('H Predicted','I Predicted','V Predicted','H Actual','I Actual','V Actual','V Measured')
