# specify server and application name
s = 'http://byu.apmonitor.com'
a = 'rocket'

from apm import *
apm(s,a,'clear all')
apm_load(s,a,'rocket.apm')
csv_load(s,a,'rocket.csv')

apm_option(s,a,'nlc.nodes',6)
apm_option(s,a,'nlc.solver',3)
apm_option(s,a,'nlc.imode',6)
apm_option(s,a,'nlc.max_iter',500)
apm_option(s,a,'nlc.mv_type',0)
apm_option(s,a,'nlc.diaglevel',0)

apm_info(s,a,'FV','tf')
apm_option(s,a,'tf.status',1)

apm_info(s,a,'MV','u')
apm_option(s,a,'u.status',1)
apm_option(s,a,'u.dcost',1e-5)

output = apm(s,a,'solve')
print(output)
y = apm_sol(s,a)

tf = y['tf'][-1]
print('Optimal Solution: ' + str(tf))

import matplotlib.pyplot as plt
import numpy as np
ns = len(y['time'])
t = np.empty((ns))
for i in range(ns):
    t[i] = y['time'][i] * tf

plt.figure(1)

plt.subplot(4,1,1)
plt.plot(t,y['s'],'r-',linewidth=2)
plt.ylabel('Position')
plt.legend(['s (Position)'])

plt.subplot(4,1,2)
plt.plot(t,y['v'],'b-',linewidth=2)
plt.ylabel('Velocity')
plt.legend(['v (Velocity)'])

plt.subplot(4,1,3)
plt.plot(t,y['m'],'k-',linewidth=2)
plt.ylabel('Mass')
plt.legend(['m (Mass)'])

plt.subplot(4,1,4)
plt.plot(t,y['u'],'g-',linewidth=2)
plt.ylabel('Force')
plt.legend(['u (Force)'])

plt.xlabel('Time')
plt.show()

