addpath('apm')

% specify server and application name
s = 'http://byu.apmonitor.com';
a = 'rocket';

apm(s,a,'clear all');
apm_load(s,a,'rocket.apm');
csv_load(s,a,'rocket.csv');

apm_option(s,a,'nlc.nodes',6);
apm_option(s,a,'nlc.solver',3);
apm_option(s,a,'nlc.imode',6);
apm_option(s,a,'nlc.max_iter',500);
apm_option(s,a,'nlc.mv_type',0);
apm_option(s,a,'nlc.diaglevel',0);

apm_info(s,a,'FV','tf');
apm_option(s,a,'tf.status',1);

apm_info(s,a,'MV','u');
apm_option(s,a,'u.status',1);
apm_option(s,a,'u.dcost',1e-5);

output = apm(s,a,'solve');
disp(output)
y = apm_sol(s,a); z = y.x;

tf = z.tf(1);
disp(['Optimal Solution: ' num2str(tf)])
t = z.time*tf;

figure(1)

subplot(4,1,1)
plot(t,z.s,'r-','LineWidth',2)
ylabel('Position')
legend('s (Position)')

subplot(4,1,2)
plot(t,z.v,'b-','LineWidth',2)
ylabel('Velocity')
legend('v (Velocity)')

subplot(4,1,3)
plot(t,z.m,'k-','LineWidth',2)
ylabel('Mass')
legend('m (Mass)')

subplot(4,1,4)
plot(t,z.u,'g-','LineWidth',2)
ylabel('Force')
legend('u (Force)')

xlabel('Time')
