# specify server and application name
s = 'http://byu.apmonitor.com'
a = 'catalyst'

from apm import *
apm(s,a,'clear all')
apm_load(s,a,'cat.apm')
csv_load(s,a,'cat.csv')

apm_option(s,a,'nlc.nodes',3)
apm_option(s,a,'nlc.solver',1)
apm_option(s,a,'nlc.imode',6)
apm_option(s,a,'nlc.mv_type',1)

apm_info(s,a,'MV','u')
apm_option(s,a,'u.status',1)
apm_option(s,a,'u.dcost',1e-6)

output = apm(s,a,'solve')
print (output)
y = apm_sol(s,a)

print ('Optimal Solution: ' + str(y['x3'][-1]))

import matplotlib.pyplot as plt
plt.figure(1)

plt.subplot(211)
plt.plot(y['time'],y['u'],'r-',linewidth=2)
plt.legend('u')
plt.ylabel('Catalyst')

plt.subplot(212)
plt.plot(y['time'],y['x1'],'b--',linewidth=2)
plt.plot(y['time'],y['x2'],'g:',linewidth=2)
plt.plot(y['time'],y['x3'],'k-',linewidth=2)
plt.legend(['A ($x_1$)','B ($x_2$)','C ($x_3$)'])
plt.ylabel('Mole Fractions')
plt.xlabel('Time')
plt.show()
