# specify server and application name
s = 'http://byu.apmonitor.com'
a = 'ex5_dynopt'

import numpy as np
from apm import *
import matplotlib.pyplot as plt

apm(s,a,'clear all')
apm_load(s,a,'ex5.apm')
csv_load(s,a,'ex5.csv')

apm_option(s,a,'nlc.nodes',4)
apm_option(s,a,'nlc.solver',1)
apm_option(s,a,'nlc.imode',6)
apm_option(s,a,'nlc.mv_type',1)

apm_info(s,a,'FV','u')
apm_option(s,a,'u.status',0)
apm_option(s,a,'u.dcost',0)

n = 11
u = np.linspace(0,1,n)
obj = np.empty((n))

plt.figure(1)

for i in range(n):
   apm_meas(s,a,'u',u[i])
   output = apm(s,a,'solve')
   y = apm_sol(s,a)
   obj[i] = 1.0-y['x1'][-1]-y['x2'][-1]
   print('Optimal Solution: ' + str(obj[i]))
   plt.subplot(3,1,1)
   plt.plot(y['time'],y['u'],'--')
   plt.subplot(3,1,2)
   plt.plot(y['time'],y['x1'],'-')
   plt.subplot(3,1,3)
   plt.plot(y['time'],y['x2'],':')

plt.figure(1)
plt.subplot(3,1,1)
plt.legend('u')
plt.ylabel('Manipulated')
plt.axis([0,1,-0.1,1.1])
plt.subplot(3,1,2)
plt.legend(['$x_1$'])
plt.ylabel('$x_1$')
plt.subplot(3,1,3)
plt.legend(['$x_2$'])
plt.ylabel('$x_2$')
plt.xlabel('Time')
   
plt.figure(2)
plt.plot(u,obj)
plt.legend(['Objective'])
plt.ylabel('Objective')
plt.xlabel('u')
plt.show()
