clear all; close all; clc
s = 'http://byu.apmonitor.com';
a = 'ex5_dynopt';

addpath('apm')

apm(s,a,'clear all');
apm_load(s,a,'ex5.apm');
csv_load(s,a,'ex5.csv');

apm_option(s,a,'nlc.nodes',4);
apm_option(s,a,'nlc.solver',1);
apm_option(s,a,'nlc.imode',6);
apm_option(s,a,'nlc.mv_type',1);

apm_info(s,a,'FV','u');
apm_option(s,a,'u.status',0);
apm_option(s,a,'u.dcost',0);

n = 11;
u = linspace(0,1,n);

figure(1)

for i = 1:n
   apm_meas(s,a,'u',u(i));
   output = apm(s,a,'solve');
   y = apm_sol(s,a); z = y.x;
   obj(i) = 1.0-z.x1(end)-z.x2(end);
   disp(['Optimal Solution: ' num2str(obj(i))])
   subplot(3,1,1)
   plot(z.time,z.u,'--');
   hold on
   subplot(3,1,2)
   plot(z.time,z.x1,'-')
   hold on
   subplot(3,1,3)
   plot(z.time,z.x2,':')
   hold on
end
   
figure(1)
subplot(3,1,1)
legend('u')
ylabel('Manipulated')
axis([0 1 -0.1 1.1])
subplot(3,1,2)
legend('x_1')
ylabel('x_1')
subplot(3,1,3)
legend('x_2')
ylabel('x_2')
xlabel('Time')
   
figure(2)
plot(u,obj)
legend('Objective')
ylabel('Objective')
xlabel('u')
