# specify server and application name
s = 'http://byu.apmonitor.com'
a = 'ex2_dynopt'

from apm import *
apm(s,a,'clear all')
apm_load(s,a,'ex2.apm')
csv_load(s,a,'ex2.csv')

apm_option(s,a,'nlc.nodes',4)
apm_option(s,a,'nlc.solver',3)
apm_option(s,a,'nlc.imode',6)
apm_option(s,a,'nlc.mv_type',1)

apm_info(s,a,'MV','u')
apm_option(s,a,'u.status',1)
apm_option(s,a,'u.dcost',0)

output = apm(s,a,'solve')
print(output)
y = apm_sol(s,a)

print('Optimal Solution: ' + str(y['x4'][-1]))

import matplotlib.pyplot as plt
plt.figure(1)

plt.subplot(211)
plt.plot(y['time'],y['u'],'r-')
plt.legend('u')
plt.ylabel('Manipulated')

plt.subplot(212)
plt.plot(y['time'],y['x1'],'r--')
plt.plot(y['time'],y['x2'],'g:')
plt.plot(y['time'],y['x3'],'k-')
plt.plot(y['time'],y['x4'],'b.-')
plt.legend(['x1','x2','x3','x4'])
plt.ylabel('Variables')
plt.xlabel('Time')
plt.show()
