# specify server and application name
s = 'http://byu.apmonitor.com'
a = 'aly_chan'

from apm import *
apm(s,a,'clear all')
apm_load(s,a,'ac1.apm')
csv_load(s,a,'ac1.csv')

apm_option(s,a,'nlc.nodes',6)
apm_option(s,a,'nlc.solver',1)
apm_option(s,a,'nlc.imode',6)
apm_option(s,a,'nlc.mv_type',1)

apm_info(s,a,'MV','u')
apm_option(s,a,'u.status',1)
apm_option(s,a,'u.dcost',1e-6)

apm_info(s,a,'SV','x1')
apm_info(s,a,'SV','x2')
apm_info(s,a,'SV','x3')

output = apm(s,a,'solve')
print (output)
y = apm_sol(s,a)

apm_web(s,a)

print ('Optimal Solution: ' + str(y['x3'][-1]))

import matplotlib.pyplot as plt
import numpy as np
plt.figure(1)

plt.subplot(211)
plt.plot(y['time'],y['u'],'r-',linewidth=2)
plt.plot(y['time'],-np.sin(y['time']),'b--',linewidth=2)
plt.legend(['u calculated','u exact'])
plt.ylabel('Manipulated')

plt.subplot(212)
plt.plot(y['time'],y['x1'],'b--',linewidth=2)
plt.plot(y['time'],y['x2'],'g:',linewidth=2)
plt.plot(y['time'],y['x3'],'r.-',linewidth=2)
plt.legend(['x1','x2','x3'])
plt.ylabel('Variables')
plt.xlabel('Time')
plt.show()
