clear all; close all; clc

s = 'http://byu.apmonitor.com';
a = 'aly_chan';

addpath('apm')
apm(s,a,'clear all');
apm_load(s,a,'ac1.apm');
csv_load(s,a,'ac1.csv');

apm_option(s,a,'nlc.nodes',6);
apm_option(s,a,'nlc.solver',1);
apm_option(s,a,'nlc.imode',6);
apm_option(s,a,'nlc.mv_type',1);

apm_info(s,a,'MV','u');
apm_option(s,a,'u.status',1);
apm_option(s,a,'u.dcost',1e-6);

apm_info(s,a,'SV','x1');
apm_info(s,a,'SV','x2');
apm_info(s,a,'SV','x3');

output = apm(s,a,'solve');
disp(output)
y = apm_sol(s,a);
z = y.x;

apm_web(s,a);

disp(['Optimal Solution: ' num2str(z.x3(end))])

figure(1)

subplot(2,1,1)
plot(z.time,z.u,'r-','LineWidth',2)
hold on
plot(z.time,-sin(z.time),'b--','LineWidth',2)
legend('u calculated','u exact')
ylabel('Manipulated')

subplot(2,1,2)
plot(z.time,z.x1,'b--','LineWidth',2)
hold on
plot(z.time,z.x2,'g:','LineWidth',2)
plot(z.time,z.x3,'r.-','LineWidth',2)
legend('x_1','x_2','x_3')
ylabel('Variables')
xlabel('Time')
