## Generate a contour plot
# Import some other libraries that we'll need
# matplotlib and numpy packages must also be installed
import matplotlib
import numpy as np
import matplotlib.pyplot as plt

# define objective function
def f(x):
    x1 = x[0]
    x2 = x[1]
    obj = 4.0*x1**4 - 4.0*x2*x1**2 + x2**2 + x1**2 - x1 + 1.0
    return obj

# Start location
x_start = [-3.0, 2.0]

# Design variables at mesh points
i1 = np.arange(-1.5, 1.5, 0.01)
i2 = np.arange(-1.5, 3.1, 0.01)
x1m, x2m = np.meshgrid(i1, i2)
f_mesh = 4.0*x1m**4 - 4.0*x2m*x1m**2 + x2m**2 + x1m**2 - x1m + 1.0

# Create a contour plot
plt.figure()
# Specify contour lines
lines = [0.76, 0.8,0.9,1.0,1.5,2.0,3.0,4.0,5.0,6.0,7.0,8.0,12.0,15.0,20.0]
# Plot contours
CS = plt.contour(x1m, x2m, f_mesh,lines)
# Label contours
plt.clabel(CS, inline=1, fontsize=10)
# Add some text to the plot
plt.xlabel('x1')
plt.ylabel('x2')
plt.grid(b=True, which='major', color='r', linestyle='--')
plt.grid(b=True, which='minor', color='r', linestyle='--')
for i in range(-1,2):
    for j in range(-1,3):
        plt.plot(i,j,'go')
        x1p = float(i)
        x2p = float(j)
        obj_pt = 4.0*x1p**4 - 4.0*x2p*x1p**2 + x2p**2 + x1p**2 - x1p + 1.0
        plt.text(x1p+0.05,x2p+0.05,str(obj_pt))

# Save the figure as a PNG
plt.savefig('contour_pts.png')
# Show the plot
plt.show()

