close all; clear all; clc

addpath('apm') % load APMonitor

s = 'http://byu.apmonitor.com';
a = 'ref_traj';

% clear prior application
apm(s,a,'clear all');

% load model and data
apm_load(s,a,'model.apm');
csv_load(s,a,'data.csv');

% specify MV / CV
apm_info(s,a,'MV','p');
apm_info(s,a,'SV','v');
apm_info(s,a,'CV','e');

%% configuration parameters
apm_option(s,a,'apm.imode',6);
apm_option(s,a,'apm.nodes',3);
apm_option(s,a,'apm.cv_type',1);
apm_option(s,a,'apm.solver',3);

%% turn on MV / CV
apm_option(s,a,'p.status',1);
apm_option(s,a,'e.status',1);

%% tune controller
apm_option(s,a,'p.lower',-100);
apm_option(s,a,'p.upper',100);
apm_option(s,a,'e.tau',5);

db = 2;
apm_option(s,a,'e.sphi',db);
apm_option(s,a,'e.splo',-db);
apm_option(s,a,'e.tr_init',0);
apm_option(s,a,'e.tau',5);

% solve and retrieve results
output = apm(s,a,'solve'); 
disp(output);

y = apm_sol(s,a); 
z = y.x;

% Plot solution
figure(1)
subplot(3,1,1)
plot(z.time,z.p,'b-')
legend('MV')
ylabel('MV')
subplot(3,1,2)
plot(z.time,z.traj+2,'k-')
hold on
plot(z.time,z.traj-2,'k-')
plot(z.time,z.v,'r--')
legend('SPHI','SPLO','CV')
ylabel('CV')
subplot(3,1,3)
plot(z.time,z.etr_hi,'k-')
hold on
plot(z.time,z.etr_lo,'k-')
plot(z.time,z.e,'r--')
legend('SPHI','SPLO','Error')
ylabel('Error')
xlabel('time')

