function y = nmpc(u)

persistent icount
persistent s
persistent a

if (isempty(icount)),
    % -------------------------------------------
    %    Setting up the NLC in APMonitor
    %    For any questions see http://apmonitor.com/wiki/index.php/Main/MATLAB
    % -------------------------------------------
    
    % Add path to APM libraries
    addpath('apm');
    
    % Select server
    s = 'http://byu.apmonitor.com';
    
    % Application name
    a = ['cstr_' int2str(1000*rand())];
    
    % Clear previous application
    apm(s,a,'clear all');
    
    % load model variables and equations
    apm_load(s,a,'reactor.apm');
    
    % load data
    csv_load(s,a,'reactor.csv');
    
    %  APM Variable Classification
    %  class = FV, MV, SV, CV
    %    F or FV = Fixed value - parameter may change to a new value every cycle
    %    M or MV = Manipulated variable - independent variable over time horizon
    %    S or SV = State variable - model variable for viewing
    %    C or CV = Controlled variable - model variable for control
    
    % Feedforwards - measured process disturbances
    
    %Parameters
    % FVs = 'v','rho','cp','mdelh','eoverr','k0','ua'
    apm_info(s,a,'FV','v');
    apm_info(s,a,'FV','rho');
    apm_info(s,a,'FV','cp');
    apm_info(s,a,'FV','mdelh');
    apm_info(s,a,'FV','k0');
    apm_info(s,a,'FV','ua');
    
    % Manipulated variables (for controller design)
    % MVs = 'tc','q','caf','tf'
    apm_info(s,a,'MV','tc');
    apm_info(s,a,'MV','q');
    apm_info(s,a,'MV','caf');
    apm_info(s,a,'MV','tf');
    
    % State variables (for display only)
    apm_info(s,a,'SV','ca');
    
    % Controlled variables
    apm_info(s,a,'CV','t');
    
    % imode = 6, switch to dynamic control
    apm_option(s,a,'nlc.imode',6);
    % nodes = 3, internal nodes in the collocation structure (2-6)
    apm_option(s,a,'nlc.nodes',3);
    % solver = 3 (IPOPT)
    apm_option(s,a,'nlc.solver',3);
    % time units (1=sec,2=min,3=hrs,etc)
    apm_option(s,a,'nlc.ctrl_units',2);
    apm_option(s,a,'nlc.hist_units',2);
    % cv type (1=l1-norm, 2=l2-norm)
    apm_option(s,a,'nlc.cv_type',1);
    % maximum iterations
    apm_option(s,a,'nlc.max_iter',200);
    
    % turn on historization to see past results
    apm_option(s,a,'nlc.hist_hor',100);
    
    % Objective for Nonlinear Control
    
    % Controlled variable (c)
    apm_option(s,a,'t.tau',1.0);
    apm_option(s,a,'t.status',1);
    apm_option(s,a,'t.fstatus',0);
    apm_option(s,a,'t.upper',400);
    
    % Manipulated variables (u)
    apm_option(s,a,'tc.upper',350);
    apm_option(s,a,'tc.dmax',10);
    apm_option(s,a,'tc.lower',250);
    apm_option(s,a,'tc.status',1);
    apm_option(s,a,'tc.fstatus',0);
    
    % Set controller mode
    apm_option(s,a,'nlc.reqctrlmode',1);
    
    % Adjust plot frequency
    apm_option(s,a,'nlc.web_plot_freq',3);
    
    icount = 0;
end

icount = icount + 1;

t_sp     = u(1);
q_meas   = u(2);
caf_meas = u(3);
tf_meas  = u(4);

deadband = 0.1;

t_upper = t_sp + deadband/2;
t_lower = t_sp - deadband/2;

% Input parameter values
apm_meas(s,a,'q',q_meas);
apm_meas(s,a,'caf',caf_meas);
apm_meas(s,a,'tf',tf_meas);

apm_option(s,a,'t.sp',t_sp);
apm_option(s,a,'t.sphi',t_upper);
apm_option(s,a,'t.splo',t_lower);

% Run APMonitor
output = apm(s,a,'solve');
disp(output);

% retrieve solution if successfully solved
status = apm_tag(s,a,'nlc.appstatus');
if (status==1),
    % Retrieve manipulated variable
    tc_newval = apm_tag(s,a,'tc.newval');
    t_model = apm_tag(s,a,'t.model');
    ca_model = apm_tag(s,a,'ca.model');    
else
    tc_newval = 300;
    t_model = 450;
    ca_model = 0;
end

if (icount==1),
    % Set to control mode after first cycle
    apm_option(s,a,'nlc.reqctrlmode',3);
    
    % Open web-viewer after first cycle
    apm_web(s,a);
end

% output new Tc value
y(1) = tc_newval;
y(2) = t_model;
y(3) = ca_model;

end
