function msg = mpc_init(s,a)

% -------------------------------------------
% Setting up APMonitor
% For any tutorials see
% http://apmonitor.com/wiki/index.php/Main/MATLAB
% -------------------------------------------

% Add path to APM libraries
addpath('apm');

% Clear previous application
apm(s,a,'clear all');

% load model variables and equations
apm_load(s,a,'mpc.apm');

% load data
csv_load(s,a,'mpc.csv');

%  APM Variable Classification
apm_info(s,a,'MV','Tc');
apm_info(s,a,'CV','T');

% Options
apm_option(s,a,'nlc.imode',6);
apm_option(s,a,'nlc.nodes',3);
apm_option(s,a,'nlc.web_plot_freq',1);
% Bounds
apm_option(s,a,'Tc.lower',250);
apm_option(s,a,'Tc.upper',350);
% Turn on parameters to control
apm_option(s,a,'Tc.status',1);
apm_option(s,a,'Tc.dmax',50);
apm_option(s,a,'Tc.fstatus',0);
apm_option(s,a,'T.status',1);
apm_option(s,a,'T.fstatus',1);
apm_option(s,a,'T.tau',1.0);

return