function output = mpc(inputs)

persistent s a icount

if (isempty(icount)),
    % Select server and application name
    s = 'http://byu.apmonitor.com';
    
    a = 'controller';
    % Initialize MPC controller
    mpc_init(s,a)
    % Initialize counter
    icount = 0;
    % first cycle, set Tc = 280
    Tc = 280;
else
    icount = icount + 1;
    % process inputs
    Tsp = inputs(1);
    T_meas = inputs(2);
    
    % Input setpoint and measurements
    apm_option(s,a,'T.sphi',Tsp+1);
    apm_option(s,a,'T.splo',Tsp-1);
    apm_meas(s,a,'T',T_meas);
    
    % Solve
    output = apm(s,a,'solve');
    disp(output)
    
    % Output parameters, check if good solution
    if (apm_tag(s,a,'nlc.appstatus')==1),
        Tc = apm_tag(s,a,'Tc.newval');
    else
        Tc = 280;
    end
end

% output Tc value
if isnan(Tc)
    % protect outputs against bad solutions
    output = 280;
else
    output = Tc;
end

if (icount==5),
    % open web-viewer
    apm_web(s,a);
end

return