from apm import *
import numpy as np

A = np.random.random((3,4))
n = np.size(A,0) # rows
m = np.size(A,1) # columns

# write model.apm
fid = open('model.apm','w')
fid.write('Constants \n')
fid.write(' n ='+str(n)+' \n')
fid.write(' \n')
fid.write('Parameters \n')
fid.write(' p[1:'+str(n)+'][1::'+str(m)+'] \n')
fid.write(' \n')
fid.write('Variables \n')
fid.write(' x \n')
fid.write('Equations \n')
fid.write(' x=p[1][1] \n')
fid.close()

# write data.csv
fid = open('data.csv','w')
for i in range(n):
    for j in range(m):
        fid.write(' p['+str(i+1)+']['+str(j+1)+'], '+str(A[i,j])+' \n')
fid.close()

s = 'http://byu.apmonitor.com'
a = 'matrix_write'

apm(s,a,'clear all')
apm_load(s,a,'model.apm')
csv_load(s,a,'data.csv')

apm(s,a,'solve')

apm_web_var(s,a)
