addpath('apm')

A = rand(3,4);
[n,m] = size(A);

% write model.apm
fid = fopen('model.apm','w');
fprintf(fid,'Constants \n');
fprintf(fid,[' n =' int2str(n) ' \n']);
fprintf(fid,' \n');
fprintf(fid,'Parameters \n');
fprintf(fid,[' p[1:' int2str(n) '][1::' int2str(m) '] \n']);
fprintf(fid,' \n');
fprintf(fid,'Variables \n');
fprintf(fid,' x \n');
fprintf(fid,'Equations \n');
fprintf(fid,' x=1 \n');
fclose(fid);

% write data.csv
fid = fopen('data.csv','w');
for i = 1:n
    for j = 1:m
        fprintf(fid,[' p[' int2str(i) '][' int2str(j) '], ' num2str(A(i,j)) ' \n']);
    end
end
fclose(fid);

s = 'http://byu.apmonitor.com';
a = 'matrix_write';

apm(s,a,'clear all')
apm_load(s,a,'model.apm');
csv_load(s,a,'data.csv');

apm(s,a,'solve')

apm_web_var(s,a);

