% clear session
clear all; close all; clc

% load APMonitor library
addpath('apm')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Step #1 - Solve model with p = 1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Step #1a - write data.csv
n = 31;
time = linspace(0,3,n);
p = ones(31,1);
x = 2 * ones(31,1);

fid = fopen('data.csv','w');

%% write time row
fprintf(fid,['time,']);
for i = 1:n-1
    fprintf(fid,[num2str(time(i)) ', ']);
end
fprintf(fid,[num2str(time(n)) '\n']);

%% write 'p' row (input parameter)
fprintf(fid,['p,']);
for i = 1:n-1
    fprintf(fid,[num2str(p(i)) ', ']);
end
fprintf(fid,[num2str(p(n)) '\n']);

%% write 'x' row (state variable initialization)
fprintf(fid,['x,']);
% imode: http://apmonitor.com/wiki/index.php/Main/Modes
% for imode=4-6, include all initialization values
% for imode=7-9, include only the initial condition for variables
imode = 7;
if ((imode>=4)&&(imode<=6))
    for i = 1:n-1
        fprintf(fid,[num2str(x(i)) ', ']);
    end
    fprintf(fid,[num2str(x(n)) '\n']);
else
    fprintf(fid,[num2str(x(1)) ', ']);
    for i = 2:n-1
        fprintf(fid,'-, ');
    end
    fprintf(fid,'-\n');
end    

% close file
fclose(fid);

%% Step 1b - Load and solve model
s = 'http://byu.apmonitor.com';
a = 'model_init';

apm(s,a,'clear all');
apm_load(s,a,'model.apm');
csv_load(s,a,'data.csv');

apm_option(s,a,'apm.time_shift',1);
apm_option(s,a,'apm.imode',imode);
output1 = apm(s,a,'solve');

%% Step 1c - Retrieve results with solution.csv
y = apm_sol(s,a);
solution1 = y.x;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Step 2 - Solve again with prior solution for initialization and
%%          p as a step from 0 to 2
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% Change to imode = 4 and change p trajectory
p(1:5) = 0;
p(6:end) = 2;

%% Step 2a - Write new row at the end of solution.csv
fname = ['solution_' a '.csv'];
fid = fopen(fname,'a');  % append to file
fprintf(fid,['p,']);
for i = 1:n-1
    fprintf(fid,[num2str(p(i)) ', ']);
end
fprintf(fid,[num2str(p(n)) '\n']);
% close file
fclose(fid);

%% Step 2b - Reload csv file for initialization
apm(s,a,'clear csv');
csv_load(s,a,fname);

%% Step 2c - Solve again but with new inputs
imode = 4;
apm_option(s,a,'apm.time_shift',0);
apm_option(s,a,'apm.imode',imode);
output2 = apm(s,a,'solve');
disp(output2)

%% Step 2d - Retrieve results with solution.csv
y = apm_sol(s,a);
solution2 = y.x;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Step 3 - Create plots
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure(1)
subplot(2,1,1)
plot(solution1.time,solution1.p,'k-','linewidth',2)
hold on
plot(solution2.time,solution2.p,'b--','linewidth',2)
legend('p_1','p_2')
subplot(2,1,2)
plot(solution1.time,solution1.x,'r--','linewidth',2)
hold on
plot(solution2.time,solution2.x,'g:','linewidth',2)
legend('x_1','x_2')
xlabel('time')

