from apm import *
import matplotlib.pyplot as plt
import csv

print "Initializing AP Monitor...",

# Select server
#server = 'http://xps.apmonitor.com'
server = 'http://byu.apmonitor.com'

# Application
app = 'sofc_estimate_danandmark'

# Clear previous application
apm(server,app,'clear all')

# load model variables and equations
apm_load(server,app,'sofc.apm')

# load data
csv_load(server,app,'data_power_stepdown.csv')

# Set up variable classifications for data flow

# Feedforwards - measured process disturbances
apm_info(server,app,'FV','sofc.m_air_total')
apm_info(server,app,'FV','sofc.tgcrbc')
# Manipulated variables (for controller design)
apm_info(server,app,'MV','sofc.Vcell')
apm_info(server,app,'MV','ejector.pPin')
apm_info(server,app,'MV','ejector.TPin')
apm_info(server,app,'MV','sofc.ncells')
apm_info(server,app,'MV','sofc.pcomb')
apm_info(server,app,'MV','sofc.m_fuel_total')
# State variables (for display only)
apm_info(server,app,'SV','sofc.tga[1]')
apm_info(server,app,'SV','sofc.powertot')
# Controlled variables (for controller design)
apm_info(server,app,'CV','sofc.tcellmin')
apm_info(server,app,'CV','sofc.dtradmax')
apm_info(server,app,'CV','sofc.uf')
apm_info(server,app,'CV','sofc.power')

# apm_option(server,app,'sofc.m_air_total.status',1)
apm_option(server,app,'sofc.m_fuel_total.status',1)
# apm_option(server,app,'sofc.m_fuel_total.lower',0)
# apm_option(server,app,'sofc.tgcrbc.status',1)
# apm_option(server,app,'sofc.tgcrbc.lower',750)
apm_option(server,app,'sofc.power.fstatus',1)
# apm_option(server,app,'sofc.power.lower',0)


# imode = 7, switch to sequential simulation
apm_option(server,app,'nlc.imode',5)
# nodes = 2, internal nodes in the collocation structure (2-6)
apm_option(server,app,'nlc.nodes',2)
# time to display on trends (1=sec, 2=min, 3=hr, etc)
apm_option(server,app,'nlc.ctrl_units',1)
# maximum time
apm_option(server,app,'nlc.max_time',600)
# maximum iterations
apm_option(server,app,'nlc.max_iter',500)

# Coldstart controller
apm_option(server,app,'nlc.reqctrlmode',1)

print "DONE."

print "Running AP Monitor...",

# Run APMonitor
out = apm(server,app,'solve')

# Turn on controller
apm_option(server,app,'nlc.reqctrlmode',3)
  
  
  
# Retrieve solution (creates solution.csv locally)
z = apm_sol(server,app)

print "Run Complete."
#for i in z:
#    print i
#print z

print "Retrieveing and plotting results..."

t = z['time']
temp = z['sofc.tsc[3]']
m_fuel_total = z['sofc.m_fuel_total']
power = z['sofc.power']

f = open('data_power_meas_stepdown.csv', 'rb')
reader = csv.reader(f)
stepdown = list(reader)

col1 = [i[0] for i in stepdown]
col2 = [i[1] for i in stepdown]

# plot results in matlab
plt.figure(1)

plt.subplot(3,1,1)
plt.plot(t,m_fuel_total,'k-')
plt.ylabel('m fuel total')
plt.legend('Total Fuel', loc=0)

plt.subplot(3,1,2)
plt.plot(t,temp,'r-')
plt.ylabel('Temp (K)')
plt.legend('Cell Temp', loc=0)

plt.subplot(3,1,3)
plt.plot(t,power,'b-')
plt.plot(t,col2, 'rx')
plt.ylabel('power (W)')
plt.xlabel('time (sec)')
plt.legend(['SOFC Power','Trajectory'], loc=0)

plt.show()

#print out
# open a web interface
#apm_web(server,app)