# Import
from apm import *
    
# Select server
s = 'http://byu.apmonitor.com'

##################################
# set up schedule simulator
##################################
a = 'projschedule'
# Clear previous application
apm(s,a,'clear all')
# Load model file
apm_load(s,a,'scheduling.apm')
# Load time points for future predictions
csv_load(s,a,'schedule2.csv')

apm_option(s,a,'nlc.imode',6)
for i in range(3):    
    apm_info(s,a,'MV', 'intb[' + str(i+1) + ']')
    apm_option(s,a,'intb[' + str(i+1) + '].status',1)

apm_option(s,a,'intb[1].dcost',100)
apm_option(s,a,'intb[2].dcost',100)
apm_option(s,a,'intb[3].dcost',100)
apm_option(s,a,'nlc.sensitivity',1)
# Solve
output = apm(s,a,'solve');
#print(output)
apm_web(s,a)    
        
y = apm_sol(s,a)

import matplotlib.pyplot as plt
plt.figure(1)
plt.subplot(3,1,1)
plt.plot(y['time'], y['profit'],'b-',linewidth=3)
plt.legend(['Profit'],loc=2)
plt.xlabel('time [hr]')
plt.ylabel('Profit [$]')

ax=plt.subplot(3,1,2)
plt.plot(y['time'], y['intb[1]'],'r-',linewidth=3)
plt.plot(y['time'], y['intb[2]'],'b:',linewidth=3)
plt.plot(y['time'], y['intb[3]'],'g--',linewidth=3)
plt.plot(y['time'], y['c'],'k--',linewidth=1)
#plt.legend(['Producing 1','Producing 2','Producing 3','Total Production'],loc=2)
plt.xlabel('time [hr]')
plt.ylabel('Binary (0/1)')
ax.set_ylim([-0.5,1.5])

plt.subplot(3,1,3)
plt.plot(y['time'], y['a[1]'],'r-',linewidth=3)
plt.plot(y['time'], y['a[2]'],'b:',linewidth=3)
plt.plot(y['time'], y['a[3]'],'g--',linewidth=3)
plt.legend(['Amount 1','Amount 2','Amount 3'],loc=2)
plt.xlabel('time [hr]')
plt.ylabel('Accumulated [m^3]')
plt.show()
