from apm import *
from sys import argv
from math import *
import random
import numpy as np
import init_pigeon_control as PC
import init_hawk_control as HC


def setPigeonSP(i, model=0, n=0):
    if model == "fly":
        PspHiHorizontal = i*60
        PspLoHorizontal = i*60
        PspHiVertical = (i*60)**(1/2.0)
        PspLoVertical = (i*60)**(1/2.0)

    elif model == "land" and n != 0:
        halfway = n/2
        if i < halfway:
            PspHiHorizontal = i*80
            PspLoHorizontal = i*80
            PspHiVertical = (i*80)**(1/2.0)
            PspLoVertical = (i*80)**(1/2.0)
        else:
            PspHiHorizontal = i*80
            PspLoHorizontal = i*80
            PspHiVertical = ((halfway - (i - halfway))*80)**(1/2.0)
            PspLoVertical = ((halfway - (i - halfway))*80)**(1/2.0)


    else:
        PspHiHorizontal = random.random()*30 + i*30
        PspLoHorizontal = random.random()*30 + i*30
        PspHiVertical = random.random()*15 + i*30
        PspLoVertical = random.random()*15 + i*30

    print 'Pigeon SPHi H: ', PspHiHorizontal
    print 'Pigeon SPLo H: ', PspLoHorizontal
    print 'Pigeon SPHi V ', PspHiVertical
    print 'Pigeon SPLo V ', PspLoVertical

    PspWHi = 500
    PspWLo = 500

    apm_option(s,pigeon,'y[3].wsphi', PspWHi)
    apm_option(s,pigeon,'y[3].wsplo',PspWLo)
    apm_option(s,pigeon,'y[4].wsphi', PspWHi/5)
    apm_option(s,pigeon,'y[4].wsplo',PspWLo/5)
    apm_option(s,pigeon,'y[3].sphi', PspHiHorizontal)
    apm_option(s,pigeon,'y[3].splo', PspLoHorizontal)    
    apm_option(s,pigeon,'y[4].sphi', PspHiVertical)
    apm_option(s,pigeon,'y[4].splo', PspLoVertical)

def runSimulation():
    esths = []
    estvs = []
    pigeonEl = [0]
    hawkEl = [0]
    pigeonThr = [0]
    hawkThr = [0]

    # initialize pigeon simulator
    print PC.init_pigeon_control(s,pigeon)
    # initialize hawk - moving horizon estimation (model) with mpc
    print HC.init_hawk_control(s,hawk)

    #initial distance from pigeon set nonzero
    #dist=1

    #time until pigeon gets away
    n = int(argv[3]) 
    solveType = int(argv[1])
    displayPigeon = 1
    displayHawk = 0
    displayTest = 1
    pigeonMove = str(argv[2])

    # # step inputs for pigeon - elevator raised all the way
    #  # initialization of hawk and pigeon i/o
    pigeonY3 = [0]
    pigeonY4 = [0]
    hawkY3 = [0]
    hawkY4 = [0]
     
    #  #wind gusts
    #  gustsh = zeros(1,n) #30.*rand(1,n)-15
    #  gustsv = zeros(1,n) #30.*rand(1,n)-15
    #  time = linspace(0,n-1,n) # time points

    for i in range(n): 

        setPigeonSP(i, pigeonMove, n)

        ## Process
        # solve process model, 1 time step
        output = apm(s,pigeon,'solve')
        pigeonResults = apm_sol(s,pigeon)

        pigeonEl = [0]
        pigeonThr = [0]
        pigeonEl += pigeonResults['u[1]']
        pigeonThr += pigeonResults['u[2]']
        pigeonY3.append(pigeonResults['y[3]'][-1])
        pigeonY4.append(pigeonResults['y[4]'][-1])

        if displayPigeon == 1:
            print 'Pigeon Y3: ', pigeonY3
            print 'Pigeon Y4 ', pigeonY4

        # HAWK TIME!
        if solveType == 1:
            if i > 1 :
                esth = 2*pigeonY3[-2] - pigeonY3[-3]
                estv = 2*pigeonY4[-2] - pigeonY4[-3]
                if displayTest == 1:
                    print 'Est H: ', esth
                    print 'Est V: ', estv
            else:
                esth = 0
                estv = 0
        elif solveType == 2:
            if i > 1:
                if i > 3:
                    t = np.linspace(0,i-1,i)
                    d3 = pigeonY3[0:-2]
                    d4 = pigeonY4[0:-2]
                    P3 = np.polyfit(t,d3,2)
                    P4 = np.polyfit(t,d4,2)
                    powers = np.zeros((3,1))
                    for j in range(3):
                        powers[j] = (i)**j
                else:
                    t = np.linspace(0,i-1,i)
                    d3 = pigeonY3[0:-2]
                    d4 = pigeonY4[0:-2]
                    P3 = np.polyfit(t,d3,i-1)
                    P4 = np.polyfit(t,d4,i-1)
                    powers = np.zeros((i,1))
                    for j in range(i):
                        powers[j] = (i)**j

                powers = np.flipud(powers)
                esth = np.matmul(P3,powers)[0]
                estv = np.matmul(P4,powers)[0]
            else:
                esth = 0
                estv = 0
        elif solveType == 3:
            if i > 1:
                if i > 4:
                    t = np.linspace(0,i-1,i)
                    d3 = pigeonY3[0:-2]
                    d4 = pigeonY4[0:-2]
                    P3 = np.polyfit(t,d3,3)
                    P4 = np.polyfit(t,d4,3)
                    powers = np.zeros((4,1))
                    for j in range(4):
                        powers[j] = (i)**j
                else:
                    t = np.linspace(0,i-1,i)
                    d3 = pigeonY3[0:-2]
                    d4 = pigeonY4[0:-2]
                    P3 = np.polyfit(t,d3,i-1)
                    P4 = np.polyfit(t,d4,i-1)
                    powers = np.zeros((i,1))
                    for j in range(i):
                        powers[j] = (i)**j

                powers = np.flipud(powers)
                esth = np.matmul(P3,powers)[0]
                estv = np.matmul(P4,powers)[0]
            else:
                esth = 0
                estv = 0
        esths.append(esth)
        estvs.append(estv)
        apm_option(s,hawk,'y[3].sphi', esth)
        apm_option(s,hawk,'y[3].splo', esth)
        apm_option(s,hawk,'y[4].sphi', estv)
        apm_option(s,hawk,'y[4].splo', estv)
        output = apm(s,hawk,'solve')
        hawkResults = apm_sol(s,hawk)
        hawkEl = [0]
        hawkThr = [0]
        hawkEl += hawkResults['u[1]']
        hawkThr += hawkResults['u[2]']
        hawkY3.append(hawkResults['y[3]'][-1])
        hawkY4.append(hawkResults['y[4]'][-1])
        print 'Hawk Y3: ', hawkY3
        print 'Hawk Y4: ', hawkY4
        #if i == 1:
             #apm_web(s,hawk)
             #apm_web(s,pigeon)

     
    # plot results

    import matplotlib.pyplot as plt
    plt.figure(1)

    plt.subplot(2,1,1)
    plt.plot(pigeonY3, pigeonY4,'b', hawkY3, hawkY4,'r', pigeonY3, pigeonY4, 'bo', hawkY3, hawkY4,'rx')
    plt.xlabel('Horizontal Position')
    plt.ylabel('Vertical Position')
    plt.legend(['Pigeon', 'Eagle'],loc=2)
    axes = plt.gca()
    #x = (hawkY3[-1] < pigeonY3[-1]) ? pigeonY3[-1] : pigeonY4[1]
    if hawkY3[-1] < pigeonY3[-1]:
        x = pigeonY3[-1]
    else:
        x = hawkY3[-1]
    y = 0
    for i in range(len(hawkY4)):
        if hawkY4[i] > y:
            y = hawkY4[i]
        elif pigeonY4[i] > y:
            y = pigeonY4[i]

    axes.set_xlim([0, x+10])
    axes.set_ylim([0, y+5])

    error = []
    timestamp = []

    for i in range(len(pigeonY3)):
        dist = ((hawkY3[i] - pigeonY3[i])**2 + (hawkY4[i] - pigeonY4[i])**2)**(1/2.0)
        timestamp.append(i)
        error.append(dist)

    plt.subplot(2,1,2)
    plt.plot(timestamp, error)
    plt.xlabel('Time Step')
    plt.ylabel('Error')
    plt.legend(['Pigeon', 'Eagle'],loc=2)

    plt.show()

if __name__ == "__main__":
    # specify server and application name
    s = 'http://byu.apmonitor.com'
    # the process
    pigeon = 'pigeon' + str(10000*random.random()) # randomize part of the name
    # the model / estimator
    hawk = 'hawk' + str(10000*random.random())  # randomize part of the name
    try:
        runSimulation()
    except:
        print "Please add arguments to call:\narg[1] = 1, 2, or 3 for solve type.\narg[2] = fly, land, or rand for pigeon movement\narg[3] = number of time steps."


