from apm import *
import random
#Linear model for the pigeon, based off of 747 model
#Pigeon can only move two-dimensionally

def init_pigeon_control(s,a):
    # clear all close all clc
    # s = 'http://byu.apmonitor.com'
    # a = 'pigeon_control'
    apm(s,a,'clear all')

    # load model and data files
    apm_load(s,a,'747p.apm')
    csv_load(s,a,'control.csv')

    # classify variables
    apm_info(s,a,'MV','u[1]') # Elevator
    apm_info(s,a,'MV','u[2]') # Thrust
    apm_info(s,a,'CV','y[3]') # Horizontal Position
    apm_info(s,a,'CV','y[4]') # Vertical Position

    apm_option(s,a,'u[1].status', 1)
    apm_option(s,a,'u[2].status', 1)
    apm_option(s,a,'y[3].status', 1)
    apm_option(s,a,'y[4].status', 1)

    # cv_type = 2
    # # apm_option(s,a,'y[3].sp',200)
    # apm_option(s,a,'y[3].wsp',100)
    # # apm_option(s,a,'y[4].sp',100)
    # apm_option(s,a,'y[4].wsp',100)

    # cv_type = 1
    apm_option(s,a,'y[3].wsphi', 1000)
    apm_option(s,a,'y[3].wsplo',40)
    apm_option(s,a,'y[4].wsphi', 1000)
    apm_option(s,a,'y[4].wsplo',40)

    # options
    apm_option(s,a,'nlc.imode', 6) # 4 = simulation
    apm_option(s,a,'nlc.nodes', 4) # 3 = collocation nodes
    apm_option(s,a,'nlc.solver', 3) # 3 = IPOPT
    apm_option(s,a,'nlc.cv_type', 1)
    # # 
    # apm_option(s,a,'u[1].dcost', 5)
    apm_option(s,a,'u[1].upper', 10)
    apm_option(s,a,'u[1].lower', -10)
    # 
    apm_option(s,a,'u[2].dcost', 50)
    apm_option(s,a,'u[2].dmax', 15)
    apm_option(s,a,'u[2].upper', 100)
    apm_option(s,a,'u[2].lower', -50)

    apm_option(s,a,'y[3].tau',.5)
    apm_option(s,a,'y[4].tau',.8)
    apm_option(s,a,'y[3].tr_init', 0)
    apm_option(s,a,'y[4].tr_init', 0)

    msg = 'Pigeon Initialized'
    return msg

if __name__ == "__main__":
    s = "http://byu.apmonitor.com/" 
    a = "pigeon_control" + str(10000*random.random())

    print init_pigeon_control(s,a)
     
    apm_option(s,a,'y[3].sphi', 500)
    apm_option(s,a,'y[3].splo', 500)
    apm_option(s,a,'y[4].sphi', 250)
    apm_option(s,a,'y[4].splo', 250)

    apm_option(s,a,'nlc.nodes', 3) 
     
    apm(s,a,'solve')
    z = apm_sol(s,a)
    
    import matplotlib.pyplot as plt

    plt.figure(1)
    plt.subplot(3,1,1)
    plt.plot(z['time'], z['u[1]'])
    plt.plot(z['time'], z['u[2]'])
    plt.xlabel('Time')
    plt.ylabel('Distance')
    plt.legend(['Elev', 'Thrust'], loc=1)
    
    plt.subplot(3,1,2)
    plt.plot(z['time'], z['y[3]'])
    plt.plot(z['time'], z['y[4]'])
    plt.xlabel('Time')
    plt.ylabel('Distance')
    plt.legend(['Horiz', 'Vert'], loc = 2)

    plt.subplot(3,1,3)
    plt.plot(z['y[3]'], z['y[4]'])
    plt.xlabel('Horiz')
    plt.ylabel('Vert')
    plt.legend(['Path'], loc = 4)
    axes = plt.gca()
    axes.set_xlim([0, 550])
    axes.set_ylim([0, 275])
    plt.show() 
