clear all;close all;clc

s = 'http://byu.apmonitor.com';
% s = 'http://localhost';
a_s = 'UAV_sim_jon';
a_m = 'UAV_mhe_jon';
a_c = 'UAV_ctrl_jon';

init_ctrl(s,a_c);
apm(s,a_c,'solve')


%%
response = apm_sol(s,a_c); y = response.x;

% desired drogure path
pipe_n = y.pipe1;
pipe_e = y.pipe2;
pipe_d = y.pipe3;

pm_n = y.xm1;
pm_e = y.xm2;
pm_d = y.xm3;

f_n = y.fm1;
f_e = y.fm2;
f_d = y.fm3;

% add noise
for i=1:length(pm_n)
    x1_sim(i,1) = pm_n(i) - 1 + 2*rand();
    x2_sim(i,1) = pm_e(i) - 1 + 2*rand();
    x3_sim(i,1) = pm_d(i) - 1 + 2*rand();
end

% output simulated data for mhe
csv_header = 'Time, xm[1], xm[2], xm[3], fm[1], fm[2], fm[3]';
f=fopen('simulator_data.csv','w');
fprintf(f,'%s\n',csv_header);
fclose(f);

csv_output = [y.time,x1_sim,x2_sim,x3_sim,f_n,f_e,f_d];
dlmwrite('simulator_data.csv',csv_output,'-append');

% run mhe
init_mhe(s,a_m);
apm(s,a_m,'solve')
apm_web(s,a_m);
response = apm_sol(s,a_m); z = response.x;

pe_n = z.xm1;
pe_e = z.xm2;
pe_d = z.xm3;

% plot
max_e = max([max(pm_e),max(pipe_e)]);
max_n = max([max(pm_n),max(pipe_n)]);
max_d = max([max(pm_d),max(pipe_d)]);
min_e = min([min(pm_e),min(pipe_e)]);
min_n = min([min(pm_n),min(pipe_n)]);
min_d = min([min(pm_d),min(pipe_d)]);
diff_e = max_e - min_e;
diff_n = max_n - min_n;
diff_d = max_d - min_d;
max_diff = max([diff_e,diff_n,diff_d]);
max_e = min_e + max_diff;
max_n = min_n + max_diff;
max_d = min_d + max_diff;

%%
figure(10),clf(10)
% uav_sim
plot3(pm_e,pm_n,pm_d,'k--','LineWidth',3.0);hold on
plot3(x2_sim,x1_sim,x3_sim,'b.');hold on
% uav_est
plot3(pe_e,pe_n,pe_d,'r--','LineWidth',3.0);hold on
% pipe
plot3(pipe_e,pipe_n,pipe_d,'color',[0.5,0.5,0.5],'LineWidth',5.0),grid on,hold on

daspect([1,1,1])

legend('Simulation UAV','Measured Data','Estimated Mass UAV','Pipeline','location','south')
xlabel('East (m)','fontsize',18)
ylabel('North (m)','fontsize',18)
zlabel('Altitude (m)','fontsize',18)
