function init_mhe(s,a)

addpath('apm')

% Clear previous alication
apm(s,a,'clear all');

apm_load(s,a,'drogue.apm');
csv_load(s,a,'simulator_data.csv');

% Names of each variable type in cell arrays
% Same as listed in the model.apm file
FVs = {'w[1]','w[2]','w[3]','flow_rate'};
MVs = {'Fm[1]','Fm[2]','Fm[3]'};
SVs = {'Vm[1]','Vm[2]','Vm[3]',...
       'Am[1]','Am[2]','Am[3]',...
       'mm'};
CVs = {'Xm[1]','Xm[2]','Xm[3]','Vm_norm'};

% Get number of each variable type
n_FVs = size(FVs,2);
n_MVs = size(MVs,2);
n_SVs = size(SVs,2);
n_CVs = size(CVs,2);

% Set up variable classifications for data flow
% Feedforwards - measured process disturbances
for i = 1:n_FVs,
    apm_info(s,a,'FV',FVs(i));
end
% Manipulated variables / parameters
for i = 1:n_MVs,
    apm_info(s,a,'MV',MVs(i));
end
% State variables (for display only)
for i = 1:n_SVs,
    apm_info(s,a,'SV',SVs(i));
end
% Controlled / Measured variables
for i = 1:n_CVs,
    apm_info(s,a,'CV',CVs(i));
end

% Options

% imode (1=ss, 2=mpu, 3=rto, 4=sim, 5=mhe, 6=nlc)
apm_option(s,a,'nlc.imode',5);

apm_option(s,a,'nlc.nodes',3);
% read discretization from CSV file
apm_option(s,a,'nlc.csv_read',1);

apm_option(s,a,'nlc.solver',1);

apm_option(s,a,'nlc.mv_type',0);

apm_option(s,a,'nlc.mv_step_hor',1);

apm_option(s,a,'nlc.max_iter',200);

for i=1:3
    % MV
    name = ['Fm[' int2str(i) ']'];
    apm_option(s,a,[name '.status'],0); 
    apm_option(s,a,[name '.fstatus'],1);
    apm_option(s,a,[name '.mv_step_hor'],1);
    
    % CV
    name = ['Xm[' int2str(i) ']'];
    apm_option(s,a,[name '.status'],0); 
    apm_option(s,a,[name '.fstatus'],1);
end

apm_option(s,a,'flow_rate.status',1);
apm_option(s,a,'flow_rate.lower',0.001);
apm_option(s,a,'flow_rate.upper',20);

% magnitude of the mothership velocity
apm_option(s,a,'Vm_norm.status',0);   
apm_option(s,a,'Vm_norm.fstatus',1);
apm_option(s,a,'Vm_norm.meas_gap',0.1);

apm_option(s,a,'nlc.time_shift',0);
apm_option(s,a,'nlc.sensitivity',1);

end

