function init_ctrl(s,a)

addpath('apm')

% Clear previous alication
apm(s,a,'clear all');

apm_load(s,a,'drogue.apm');
csv_load(s,a,'pipeline_medium.csv');

% Names of each variable type in cell arrays
% Same as listed in the model.apm file
FVs = {'w[1]','w[2]','w[3]','sp',...
    'g_dr[1]','g_dr[2]','g_dr[3]','vdr','Adr'};
MVs = {'Fm[1]','Fm[2]','Fm[3]'};
SVs = {'Xm[1]','Xm[2]','Xm[3]',...
    'Vm[1]','Vm[2]','Vm[3]',...
    'Am[1]','Am[2]','Am[3]',...
    };
CVs = {'Vm_norm'};

% Get number of each variable type
n_FVs = size(FVs,2);
n_MVs = size(MVs,2);
n_SVs = size(SVs,2);
n_CVs = size(CVs,2);

% Set up variable classifications for data flow
% Feedforwards - measured process disturbances
for i = 1:n_FVs,
    apm_info(s,a,'FV',FVs(i));
end
% Manipulated variables / parameters
for i = 1:n_MVs,
    apm_info(s,a,'MV',MVs(i));
end
% State variables (for display only)
for i = 1:n_SVs,
    apm_info(s,a,'SV',SVs(i));
end
% Controlled / Measured variables
for i = 1:n_CVs,
    apm_info(s,a,'CV',CVs(i));
end

% Options

% imode (1=ss, 2=mpu, 3=rto, 4=sim, 5=mhe, 6=nlc)
apm_option(s,a,'nlc.imode',6);

apm_option(s,a,'nlc.nodes',3);
% controller mode (1=simulate, 2=predict, 3=control)
apm_option(s,a,'nlc.reqctrlmode',3);

% time units (1=sec,2=min,3=hrs,etc)
apm_option(s,a,'nlc.ctrl_units',1);

% set controlled variable error model type
apm_option(s,a,'nlc.cv_type',1);
apm_option(s,a,'nlc.mv_type',0);

% read discretization from CSV file
apm_option(s,a,'nlc.csv_read',1);

apm_option(s,a,'nlc.solver',1);

apm_option(s,a,'nlc.mv_step_hor',3);

apm_option(s,a,'nlc.max_iter',200);

for i=1:3
    % MV
    name = ['Fm[' int2str(i) ']'];
    apm_option(s,a,[name '.upper'],10.0);
    apm_option(s,a,[name '.dmax'],1);
    apm_option(s,a,[name '.lower'],-10.0);
    apm_option(s,a,[name '.status'],1); 
    apm_option(s,a,[name '.fstatus'],0);
    apm_option(s,a,[name '.mv_step_hor'],1);
    
    % CV
    name = ['err[' int2str(i) ']'];
    apm_info(s,a,'CV',name);
    apm_option(s,a,[name '.sphi'],0.1);
    apm_option(s,a,[name '.splo'],-0.1);
    apm_option(s,a,[name '.status'],1);
    apm_option(s,a,[name '.wsphi'],100);
    apm_option(s,a,[name '.wsplo'],100);
    apm_option(s,a,[name '.tr_init'],1);
    apm_option(s,a,[name '.tr_open'],5);
    apm_option(s,a,[name '.tau'],2);
    apm_option(s,a,[name '.fstatus'],0);
end

% modify for priority for height
name = 'err[3]';
apm_option(s,a,[name '.wsphi'],1);
apm_option(s,a,[name '.wsplo'],100);

% magnitude of the mothership velocity
apm_option(s,a,'Vm_norm.sphi',10.0);
apm_option(s,a,'Vm_norm.splo',0.0);
apm_option(s,a,'Vm_norm.status',1);   
apm_option(s,a,'Vm_norm.wsphi',1);
apm_option(s,a,'Vm_norm.wsplo',1);
% use dead-band (tr_init=0)
apm_option(s,a,'Vm_norm.tr_init',0);
apm_option(s,a,'Vm_norm.fstatus',0);

end

