# Import
from apm import *
import matplotlib.pyplot as plt

# Select server
s = 'http://byu.apmonitor.com'

#####################################################
# set up Hybrid Car Simulator (without using battery)
#####################################################

sim = 'HybridCarOptSim'
# Clear previous application
apm(s,sim,'clear all')
# Load model file
apm_load(s,sim,'ModelHybridCarSim.apm')
# Load time points for future predictions
csv_load(s,sim,'Additional Routes/Provo to SLC/Provo to SLC.csv')
# APM Variable Classification
# class = FV, MV, SV, CV
#   F or FV = Fixed value - parameter may change to a new value every cycle
#   M or MV = Manipulated variable - independent variable over time horizon
#   S or SV = State variable - model variable for viewing
#   C or CV = Controlled variable - model variable for control

apm_info(s,sim,'SV','final')
apm_info(s,sim,'SV','v')
apm_info(s,sim,'SV','x')
apm_info(s,sim,'SV','h')
apm_info(s,sim,'SV','h.prev')
apm_info(s,sim,'SV','v.prev')
apm_info(s,sim,'SV','x.prev')
apm_info(s,sim,'SV','totemotor')
apm_info(s,sim,'SV','emotorintegral')

# Options
# set number of nodes for collocation
apm_option(s,sim,'nlc.nodes',3)
# imode (1=ss, 2=mpu, 3=rto, 4=sim, 5=mhe, 6=nlc)
# Use dynamic Optimization
apm_option(s,sim,'nlc.imode',4)


# solve
sim_output = apm(s,sim,'solve')
#print sim_output

# retrieve solution
simz = apm_sol(s,sim)

apm_web(s,sim)

## plot results
plt.figure(1)
plt.subplot(211)

plt.plot(simz['time'],simz['totemotor'],'b',linewidth=2.0)
plt.ylabel('Energy from Motor (J)')

plt.subplot(212)
plt.plot(simz['time'],simz['emotorintegral'],'b',linewidth=2.0)
plt.ylabel('Integral of Motor Energy (J)')
plt.xlabel('time (s)')




##################################
# set up Hybrid Car Optimizer
##################################
a = 'HybridCarOptInteger'
# Clear previous application
apm(s,a,'clear all')
# Load model file
apm_load(s,a,'ModelHybridCarInteger.apm')
# Load time points for future predictions
csv_load(s,a,'Additional Routes/Provo to SLC/Provo to SLC.csv')
# APM Variable Classification
# class = FV, MV, SV, CV
#   F or FV = Fixed value - parameter may change to a new value every cycle
#   M or MV = Manipulated variable - independent variable over time horizon
#   S or SV = State variable - model variable for viewing
#   C or CV = Controlled variable - model variable for control
apm_info(s,a,'SV','final')
apm_info(s,a,'SV','v')
apm_info(s,a,'SV','x')
apm_info(s,a,'SV','h')
apm_info(s,a,'SV','h.prev')
apm_info(s,a,'SV','v.prev')

apm_info(s,a,'SV','x.prev')
#apm_info(s,a,'MV','intcharge')
#apm_info(s,a,'MV','intdischarge')
apm_info(s,a,'MV','int_charge')
apm_info(s,a,'MV','batterye')
#apm_info(s,a,'SV','ratecharge')
apm_info(s,a,'SV','currentcharge')

apm_info(s,a,'SV','totemotor')
apm_info(s,a,'SV','emotorintegral')
# Options
# turn on historization to see past results in web-viewer
#apm_option(s,a,'nlc.hist_hor',150)
# set web plot update frequency
#apm_option(s,a,'nlc.web_plot_freq',3)
# set number of nodes for collocation
apm_option(s,a,'nlc.nodes',3)
# imode (1=ss, 2=mpu, 3=rto, 4=sim, 5=mhe, 6=nlc)
# Use dynamic Optimization
apm_option(s,a,'nlc.imode',6)
apm_option(s,a,'nlc.solver',1)
apm_option(s,a,'nlc.max_iter',1200)
# turn on MVs (0 = off, 1 = on)
#apm_option(s,a,'intdischarge.status',1)
#apm_option(s,a,'intdischarge.dcost',0.001)
#apm_option(s,a,'intcharge.status',1)
#apm_option(s,a,'intcharge.dcost',0.001)
apm_option(s,a,'int_charge.status',1)
apm_option(s,a,'batterye.status',1)



# solve
#apm(s,a,'solve')
solver_output = apm(s,a,'solve')
print solver_output

# retrieve solution
z = apm_sol(s,a)

apm_web(s,a)



#z = solver_output

## plot results
plt.figure(2)
plt.subplot(311)
plt.plot(z['time'],z['int_charge'],'r-',linewidth=2.0)
#plt.legend(['intDischarge'])
plt.legend(['Battery Discharge (On/Off)'])

plt.subplot(312)
plt.plot(z['time'],z['currentcharge'],'b-',linewidth=2.0)
plt.legend(["Battery's stored energy (J)"])
#plt.legend(['availablecharge'])

plt.subplot(313)
plt.plot(z['time'],z['totemotor'],'k',linewidth=2.0)
plt.plot(z['time'],z['batterye'],'b--',linewidth=2.0)
plt.legend(['Energy from Motor (J)','Energy from Battery (J)'])

#plt.subplot(414)
#plt.plot(z['time'],z['emotorintegral'],'k',linewidth=2.0)
#plt.ylabel('Integral of Motor Energy')
plt.xlabel('time (s)')


plt.figure(3)
plt.subplot(211)
plt.plot(simz['time'],simz['totemotor'],'b-',linewidth=2.0)
plt.plot(z['time'],z['totemotor'],'r-',linewidth=2.0)

plt.legend(['Without Battery','With Optimized Battery'])
plt.ylabel('Energy from Motor (J)')

plt.subplot(212)
plt.plot(z['time'],z['emotorintegral'],'r-',linewidth=2.0)
plt.plot(simz['time'],simz['emotorintegral'],'b-',linewidth=2.0)

plt.ylabel('Integral of Motor Energy (J)')
plt.xlabel('time (s)')

plt.figure(4)

plt.subplot(211)
plt.plot(z['x'],z['h'],'r-',linewidth=2.0)
plt.ylabel('Elevation (m)')

plt.subplot(212)
plt.plot(z['x'],z['v'],'r-',linewidth=2.0)
plt.ylabel('Velocity (m/s)')
plt.xlabel('position (m)')

plt.show()




