function msg = mpc_init(s,a)

addpath('apm')
apm(s,a,'clear all');
apm_load(s,a,'model.apm');
csv_load(s,a,'data.csv');

% Configure solver
apm_option(s,a,'nlc.nodes',2);           % Number of collocation nodes to use (3 = 2 interior nodes)
apm_option(s,a,'nlc.solver',1);          % The type of solver. 1 = default ...
apm_option(s,a,'nlc.web_plot_freq',5);
apm_option(s,a,'nlc.sensitivity',1);     % Turn on the sensitivity analysis

% Define variables
apm_info(s,a,'SV','turbine.te');
apm_option(s,a,'turbine.te.status',1);
apm_option(s,a,'turbine.te.fstatus',1);
apm_option(s,a,'turbine.te.wmodel',0);
% apm_option(s,a,'turbine.te.tau',10);

apm_info(s,a,'SV','compressor.w');
apm_option(s,a,'compressor.w.status',1);
apm_option(s,a,'compressor.w.fstatus',1);
apm_option(s,a,'compressor.w.wmodel',0);

% Controlled variables
apm_info(s,a,'CV','combustor.tf');
apm_option(s,a,'combustor.tf.status',1);
apm_option(s,a,'combustor.tf.fstatus',1);  % used to be 0 %
apm_option(s,a,'combustor.tf.wmodel',0);  % Don't penalize dev. from prev. model value
apm_option(s,a,'combustor.tf.wmeas',10);
apm_option(s,a,'combustor.tf.lower',0);
apm_option(s,a,'combustor.tf.upper',1370);

apm_info(s,a,'CV','steamturbine.total_power');
apm_option(s,a,'steamturbine.total_power.status',1);
apm_option(s,a,'steamturbine.total_power.fstatus',1);  % Turned off %
apm_option(s,a,'steamturbine.total_power.wmodel',0);
apm_option(s,a,'steamturbine.total_power.wmeas',10);
apm_option(s,a,'steamturbine.total_power.tau',1);  % Added new %
% Adding a negative cost is how you maximize the power here:
apm_option(s,a,'steamturbine.total_power.cost',0);   % Used to be -100000
apm_option(s,a,'steamturbine.total_power.wsplo',200);
apm_option(s,a,'steamturbine.total_power.wsphi',20);
% Manipulated variables
apm_info(s,a,'MV','compressor.thetaigv');    
apm_option(s,a,'compressor.thetaigv.status',1);
apm_option(s,a,'compressor.thetaigv.fstatus',0);
apm_option(s,a,'compressor.thetaigv.lower',11.5);         % Lower bound for parameter
apm_option(s,a,'compressor.thetaigv.upper',85);           % Uppder bound for parameter
apm_option(s,a,'compressor.thetaigv.dmax',1e7);
apm_option(s,a,'compressor.thetaigv.dcost',1.0);          % Delta cost function, penalizing movement
apm_option(s,a,'compressor.thetaigv.cost',0);

apm_info(s,a,'MV','combustor.wf');
apm_option(s,a,'combustor.wf.status',1);   
apm_option(s,a,'combustor.wf.fstatus',0);  % Check if moves are being implimented
apm_option(s,a,'combustor.wf.lower',0.1);             %  2 Lower bound for parameter
apm_option(s,a,'combustor.wf.upper',20.2);          %  10.2 Upper bound for parameter
apm_option(s,a,'combustor.wf.dmax',1e7);
apm_option(s,a,'combustor.wf.dcost',0.0);          % Delta cost function, penalizing movement
apm_option(s,a,'combustor.wf.cost',0.25);

% reference trajectory tuning
apm_option(s,a,'nlc.traj_init',2);
apm_option(s,a,'nlc.traj_open',0.5);

msg = 'Successful initialization';

return
