function [outputs] = mpc(inputs)

persistent first s a

Total_Power = inputs(1)
Tf = inputs(2);
Te = inputs(3);
W = inputs(4);
Power_sp = inputs(5)
clock = inputs(6);

if clock <= 5 % isempty(first)
    % initialization
    s = 'http://xps.apmonitor.com'; % could use byu
    a = ['PowerPlantModel' int2str(rand()*10000)];
    msg = mpc_init(s,a)
end

% Input measurement values from the Simulink model to APMonitor
apm_meas(s,a,'steamturbine.total_power',Total_Power);
apm_meas(s,a,'combustor.tf',Tf);
apm_meas(s,a,'turbine.te',Te);
apm_meas(s,a,'compressor.w',W);




deadband = .5;
sphi_1 = Power_sp + deadband * 2;
splo_1 = Power_sp + deadband;
%apm_option(s,a,'steamturbine.total_power.sp',Power_sp);
apm_option(s,a,'steamturbine.total_power.sphi',sphi_1);
apm_option(s,a,'steamturbine.total_power.splo',splo_1);
% In the model file, Total_Power is the desired control variable


% % This set point for Te doesn't seem to be working
% sphi = Te_sp + 3;
% splo = Te_sp - 3;
% apm_option(s,a,'turbine.te.sphi',sphi);
% apm_option(s,a,'turbine.te.splo',splo);
% apm_option(s,a,'turbine.te.tau',5);     %Changes form sp to tau


% This is new:
% Configure objective function
%apm_option(s,a,'nlc.mv_type',0)        % Manipulated Variable type: 0 = zero order hold, 1 = linear

% Controlled variable error model type: 1=linear, 2=squared, 3=approximate linear
apm_option(s,a,'nlc.ev_type',1);        % 1 = l-r norm ; 2 = squared error
apm_option(s,a,'nlc.cv_type',1);

if clock <= 5 % isempty(first)
    % nlc.imode options: 1=ss, 2=mpu, 3=rto, 4=sim, 5=est, 6=ct, 7 = dyn sim seq
    apm_option(s,a,'nlc.imode',1);           % 4 = dynamic simulation simulataneous (7 = sim seq)
    solver_output = apm(s,a,'solve');
    %disp(solver_output)                     % The solve command
    
end

%print solver_output
apm_option(s,a,'nlc.imode',6);
solver_output = apm(s,a,'solve');              % The solve command



if clock <= 5
    apm_web(s,a);
end
% check for successful solution
status = apm_tag(s,a,'nlc.appstatus');
if status==1,
    y = apm_sol(s,a);
    u_IGV = apm_tag(s,a,'compressor.thetaigv.newval');
    u_fuel = apm_tag(s,a,'combustor.wf.newval');         
else
    apm_web_root(s,a);
    solver_output
    disp('Error: Did not converge to a solution');
    u_IGV = apm_tag(s,a,'compressor.thetaigv.lstval');
    u_fuel = apm_tag(s,a,'combustor.wf.lstval');  
    apm_option(s,a,'nlc.imode',1);           % 4 = dynamic simulation simulataneous (7 = sim seq)
    solver_output = apm(s,a,'solve');
end


%z = apm_sol(s,a);


outputs(1) = u_IGV;
outputs(2) = u_fuel;


return