%global gamma_c Wn eta_c LHV eta_comb Cph Wfn gamma_h eta_t Cpc PR
%global Ta0 Pa0 theta0 A0 A1 A2 thetaMAX

%clear all; close all; clc

Power_Total = 0;
u_IGV = 50;
u_fuel = 10;

% Thermal Energy Storage (TES) Details
n_tes = 10;             % number of TES nodes
R2 = 0.08206;			% L-atm/mol-K % Could pull in through function
T_ref = 298;            % K
k_stone = 1.7;			% W/m-K
k_air = ones(n_tes,1); % W/m-K
h = ones(n_tes,1);
Nu = ones(n_tes,1);
Pr = ones(n_tes,1);
Re = ones(n_tes,1);
Vol_air = ones(n_tes,1);
v_air = ones(n_tes,1);
rho_stone = 2403;		% kg/m^3
sigma = 5.67e-8;		% W/m2-K4 (Stefan-Boltzmann constant)
epsilon = 0.96;			% emissivity of cement, red (200??C)
D = 5;                  % m, tank diameter
len = 10;               % m, tank length
dp = 0.15;              % sphere diameter (m)
pi = 3.1415926;			% pi
pct = 0.7;              % pct stone in tank (density)
A_tank = pi * D^2 / 4;	% Cross-sectional area of tank (m^2)	
V_tank = A_tank * len;  % Volume of tank (m^3)
Ac = pct * A_tank;		% Cross sectional area of stone (m^2)
SA = 137.445;			% Surface area of stone / slice (m^2)
x = len / n_tes;                % Discretization width (m)
A_air = (1 - pct) * A_tank;     % Cross-sectional area that air passes through (m^2)
Convection = 0;
Conduction = 0;
Radiation = 0;

% W = 475/60; % (kg/min)
% GD = W / A_air / dp * 2.204621 / 3.28084^3 * 3600; % lb/hr-ft3
% h = 0.652 * GD^0.7 * 0.29307 * 3.28084^3 / 1.8; % W/m3-K
% h = 12 ...

T_stone0 = ones(n_tes,1)*298;   %K, TES stone node initial conditions
T_air0 = ones(n_tes,1)*298;     %K, TES air node initial conditions
q_cond = zeros(n_tes,1);
q_conv = zeros(n_tes,1);
q_rad = zeros(n_tes,1);
Cp_air = ones(n_tes,1)*300;
Cp_stone = ones(n_tes,1)*1584;
rho_air = zeros(n_tes,1);
mu_air2 = zeros(n_tes,1);
m_air = zeros(n_tes,1);
m_stone = ones(n_tes,1) * V_tank * rho_stone * pct / n_tes;	% Mass of stone in each slice (kg)
flag = 0; % For plot axis resizing purposes
C = [2.8958e04; 9.3900e03; 3.0120e03; 7.5800e03; 1.4840e03]; % Heat capacity of air
B = [-0.22824; 3.3801e5; -3.4738e7; 110.88; -2378.1]; % Heat capacity of stone (granite)
E = [3.1417E-04; 7.7860E-01; -7.1160E-01; 2.1217E+03]; % Air thermal conductivity
F = [1.4250E-06; 5.0390E-01; 1.0830E+02; 0]; % Viscosity of air (kg/m/s = Pa*s)

%External heat loss (TES)
wall_1 = 0.05; % m (steel wall thickness)
wall_2 = 0.15; % m (insulation thickness)
wall_3 = 0.01; % m (outer metal thickness)
thick = 0.21; % m (TES wall total thickness)
A_inner = 2 * pi * (D / 2) * len / n_tes; % Inner surface area
A_outer = 2 * pi * (D / 2 + thick) * len / n_tes; % Outer surface area
A_lm = (A_outer - A_inner) / log(A_outer / A_inner); % Log mean surface area
T_wall_inner = ones(n_tes,1)*298;
T_wall_outer = ones(n_tes,1)*298;
U_wall = 0.1; % W/m2-K (heat loss through TES wall)
q_external = zeros(n_tes,1); % Heat loss through tank wall

% receiver details
R = 8.314; %m^3*kPa/kmol*K
MW_air = 28.97; %kg/kmol
sig = 5.6704e-11; %kW/(m^2*K^4), Stefan-Boltzmann constant
mu_air = 1.983e-5; %kg/(m*s), absolute viscosity of air at 300K
emiss_rec = 0.1; %receiver emissivity
h_node_rec = 2; %m, receiver node height
n_rec = 10; %number of receiver nodes
U = .010; % kW/m^2K
w_rec = 10; % m, width of receiver
d_rec = 5; %m, depth of receiver
Trec0 = ones(n_rec,1)*550; %550; %K, receiver node initial condition

eta_c = 0.86;
eta_comb = 0.99;
Cpc = 1.005; %kJ/kg*K, heat capacity of air (cold)
Cph = 1.157; %kJ/kg*K, heat capacity of air (hot)
gamma_c = 1.4;
gamma_h = 1.33;
eta_t = 0.89;
Wn = 537; %kg/s, nominal air flow
Wfn = 10.2; %kg/s, nominal fuel flow
LHV = 46000; %(kJ/kg) LHV of natural gas - not from paper - 
%http://www.engineeringtoolbox.com/heating-values-fuel-gases-d_823.html
PR = 15.4; %compressor pressure ratio
Ta0 = 298.15; %ambient temp, K
Pa0 = 101.325; %kPa
theta0 = 11.6; %reference IGV angle in degrees
thetaMAX = 85; %maximum IGV angle
A0 = .945; A1 = -7.8; A2 = 39;

T = 0.05; %speed governor time constant
Ti = 18.5; 
Tw = .4789; %Air control time constant
Kf = 0; % Fuel system ext. feedback const. 
Tv = 0.04; %Valve positioner time constant
K6 = 0.1062; %fuel valve lower limit
T5 = 0.5;
Tt = 100;
Tf = 0.26; %fuel system time constant
T6 = 60; %Time constant of Tf control
T4 = 1.7; %thermocouple time constant
K4 = 0.85; %gain of rad shield
T3 = 12.2; % Rad shield time constant
K5 = 0.15; %Gain of rad. shield
K3 = .8938; %Ratio of fuel adjustment
Tg = 0.05;
Tcd = .16;

PI = 160;
TI = 298;
Pa = 101.325; %kPa

Hsh = 3231; %kJ/kg, superheated steam enthalpy at 30 bar and 400 C 
Hsv = 2809; %kJ/kg, saturated vapor enthalpy at 30 bar and 233.8 C
%(http://www.engineeringtoolbox.com/enthalpy-superheated-steam-d_1130.html)
Hfg = 1793.94; %kJ/kg, heat of vaporization at 30 bar
%(http://www.engineeringtoolbox.com/saturated-steam-properties-d_457.html)
Cpw = 4.78; %kJ/kgK, Cp of liquid water
delTbfw = 120; %k, delta H of boiler feed water (assume makeup water mixes...
%with saturated liquid to bring temp down by this much

dHtot = (Hsh-Hsv)+Hfg+Cpw*delTbfw; %kJ/kg, total water to steam specific 
%enthalpy

Hsv1bar = 2676; %specific enthalphy of sat steam at 1 bar
%http://www.engineeringtoolbox.com/saturated-steam-properties-d_101.html

Tao = 298; %450; %exhaust air outlet temp
eta_HRSG = 0.95; %HRSG efficiency

Hliq = 350.6; %kJ/kg, condensed liquid enthalpy (@0.55 bar)
xsat = 0.9; %percent saturation
Hfg = 2299; %kJ/kg, heat of vaporization at 0.55 bar
%from http://www.engineeringtoolbox.com/saturated-steam-properties-d_101.html
Hcond = Hliq + xsat*Hfg; %total enthalpy of condensed state at 0.55 bar

dHst = Hsh - Hcond; %kJ/kg, delta H for steam turbine

eta_st = 0.95; %efficiency of steam turbine/generator

%% solar receiver model parameters





