% Plots

close all;

% Plot plant data in a single plot
figure
plot(Plant_Data)
title('Plant Data')
legend('IGV Angle','T_Solar','T_Storage','Fuel Flow','Air Flow',...
    'Firing T','Exhaust T','Turbine','Steam Turbine');

% Plot plant data with a 2x2 plot
figure
xmax = 20; % Set this manually
subplot(2,2,1)
plotyy(Plant_Data.Time,Plant_Data.Data(:,8),Plant_Data.Time,Plant_Data.Data(:,9))
% plot(Plant_Data.Time,Plant_Data.Data(:,8))
title('Power')
% hold on
% plot(Plant_Data.Time,Plant_Data.Data(:,9))
xlim([0 xmax])
legend('Air Turbine','Steam Turbine')
%set(gca, 'XTickLabel', []);

subplot(2,2,2)
plot(Plant_Data.Time,Plant_Data.Data(:,6))
title('Temperature')
hold on
plot(Plant_Data.Time,Plant_Data.Data(:,2))
plot(Plant_Data.Time,Plant_Data.Data(:,7))
plot(Plant_Data.Time,Plant_Data.Data(:,3))
legend('Firing T','Solar T','Exhaust T','Storage T')
xlim([0 xmax])
%set(gca, 'XTickLabel', []);

subplot(2,2,3)
%plot(Plant_Data.Time,Plant_Data.Data(:,4))
plotyy(Plant_Data.Time,Plant_Data.Data(:,5),Plant_Data.Time,Plant_Data.Data(:,4))
title('Flow Rates')
% hold on
% plot(Plant_Data.Time,Plant_Data.Data(:,5))
legend('Air Flow','Fuel Flow')
xlim([0 xmax])
%set(gca, 'XTickLabel', []);

subplot(2,2,4)
plot(Plant_Data.Time,Plant_Data.Data(:,1))
title('IGV Angle')
legend('IGV Angle')
xlim([0 xmax])


if flag == 0
    % Re-define the time series to hours
    T_air.Time = T_air.Time./60;
    T_stone.Time = T_stone.Time./60;
    Convection.Time = Convection.Time./60;
    Conduction.Time = Conduction.Time./60;
    Radiation.Time = Radiation.Time./60;
    
    % Change heat transfer time series from W to kW
    Convection.Data = Convection.Data./1000;
    Conduction.Data = Conduction.Data./1000;
    Radiation.Data = Radiation.Data./1000;
    
    % Change temperatures from K to C
    T_air.Data = T_air.Data - 273.15;
    T_stone.Data = T_stone.Data - 273.15;
    
    flag = 1;
end

% Change x label to not be in scientific notation
%set(gca,'XTick',x)
%set(gca,'XTickLabel',sprintf('%3.4f|',x))
%set(gca,'YTick',y)
%set(gca,'YTickLabel',sprintf('%+1.2f|',y))


% Plot external heat losses
figure
plot(External)
% Define derivatives of T_wall_inner and have them change, and remove heat from stone...


% Plot air and stone temperatures
figure
plot(T_air.Time,T_air.Data(:,1),'r-')
title('Thermal Energy Storage')
hold on
plot(T_stone.Time,T_stone.Data(:,1),'b--')
legend('air','stone','Location','northwest')
for i = 2:10
    plot(T_air.Time,T_air.Data(:,i),'r-')
end
for i = 2:10
    plot(T_stone.Time,T_stone.Data(:,i),'b--')
end
ylabel('Temperature (C)')
xlabel('Time (hours)')
%ax = gca;
%ax.XTick = [0 12 24 36 48 60 72];
%xlim([0 72])

% All on vertical subplots
figure
subplot(1,3,1)
plot(Radiation)
    % Change Radiation y-axis labels to not be in scientific notation
    curtick = get(gca, 'YTick');
    set(gca, 'YTickLabel', cellstr(num2str(curtick(:))));
title('Radiation')
ylabel('Heat Transfer Rate (kW)')
xlabel('')
%ax = gca;
%ax.XTick = [0 12 24 36 48 60 72];
%xlim([0 72])
subplot(1,3,2)
plot(Convection)
    % Change Convection y-axis labels to not be in scientific notation
    curtick = get(gca, 'YTick');
    set(gca, 'YTickLabel', cellstr(num2str(curtick(:))));
title('Convection')
ylabel('')
xlabel('Time (hours)')
%ax = gca;
%ax.XTick = [0 12 24 36 48 60 72];
%xlim([0 72])

legend('Node 1','Node 2','Node 3','Node 4','Node 5','Node 6','Node 7','Node 8','Node 9','Node 10',...
    'Location','northeast')
subplot(1,3,3)
plot(Conduction)
title('Conduction')
ylabel('')
xlabel('')
%ax = gca;
%ax.XTick = [0 12 24 36 48 60 72];
%xlim([0 72])



% % All on horizontal subplots
% figure
% subplot(3,1,1)
% plot(Convection)
% subplot(3,1,2)
% plot(Conduction)
% subplot(3,1,3)
% plot(Radiation)

% % All on same plot
% plot(Convection)
% hold on
% plot(Conduction)
% plot(Radiation)


% Old Code

%co=get(gca,'ColorOrder');
%set(gcf,'DefaultAxesColorOrder',co([1 1 1 1 1 1 1],:));
%set(gcf,'DefaultAxesColorOrder',co([2 2 2 2 2 2 2],:));
%set(gcf,'DefaultAxesColorOrder',co([1 2 3 4 5 6 7],:));

% co=get(gca,'ColorOrder');
% set(gcf,'DefaultAxesColorOrder',co([7 7 7 7 7 7 7],:));

%plot(T_air)
%hold on

%co=get(gca,'ColorOrder');

%set(gcf,'DefaultAxesColorOrder',co([2 2 2 2 2 2 2],:));

%plot(T_stone)

%T_stone.Data(:,1)
