% Plot step test

close all;

% Plot plant data with a 2x2 plot
figure
%xmax = 200; % Set this manually
subplot(2,2,1)
plotyy(Plant_Data.Time,Plant_Data.Data(:,8),Plant_Data.Time,Plant_Data.Data(:,9))
% plot(Plant_Data.Time,Plant_Data.Data(:,8))
title('Power (MW)')
% hold on
% plot(Plant_Data.Time,Plant_Data.Data(:,9))
%xlim([0 xmax])
legend('Air Turbine','Steam Turbine','Total Power','Location','northeast')
%set(gca, 'XTickLabel', []);

subplot(2,2,2)
plot(Plant_Data.Time,Plant_Data.Data(:,6))
title('Temperature (K)')
hold on
plot(Plant_Data.Time,Plant_Data.Data(:,2))
plot(Plant_Data.Time,Plant_Data.Data(:,7))
plot(Plant_Data.Time,Plant_Data.Data(:,3))
legend('Firing T','Solar T','Exhaust T','Storage T','Location','northeast')
%xlim([0 xmax])
%set(gca, 'XTickLabel', []);

subplot(2,2,3)
%plot(Plant_Data.Time,Plant_Data.Data(:,4))
plotyy(Plant_Data.Time,Plant_Data.Data(:,5),Plant_Data.Time,Plant_Data.Data(:,4))
title('Flow Rates (kg/s)')
% hold on
% plot(Plant_Data.Time,Plant_Data.Data(:,5))
legend('Air Flow','Fuel Flow (MV)','Location','northeast')
%xlim([0 xmax])
%set(gca, 'XTickLabel', []);

subplot(2,2,4)
plot(Plant_Data.Time,Plant_Data.Data(:,1))
title('IGV Angle')
legend('IGV Angle (MV)','Location','northeast')
%xlim([0 xmax])

% 
% % Plot plant data with a 4x1 plot
% figure
% %xmax = 200; % Set this manually
% subplot(4,1,1)
% plotyy(Plant_Data.Time,Plant_Data.Data(:,8),Plant_Data.Time,Plant_Data.Data(:,9))
% % plot(Plant_Data.Time,Plant_Data.Data(:,8))
% title('Power')
% % hold on
% % plot(Plant_Data.Time,Plant_Data.Data(:,9))
% %xlim([0 xmax])
% legend('Air Turbine','Steam Turbine')
% %set(gca, 'XTickLabel', []);
% 
% subplot(4,1,2)
% plot(Plant_Data.Time,Plant_Data.Data(:,6))
% title('Temperature')
% hold on
% plot(Plant_Data.Time,Plant_Data.Data(:,2))
% plot(Plant_Data.Time,Plant_Data.Data(:,7))
% plot(Plant_Data.Time,Plant_Data.Data(:,3))
% legend('Firing T','Solar T','Exhaust T','Storage T')
% %xlim([0 xmax])
% %set(gca, 'XTickLabel', []);
% 
% subplot(4,1,3)
% %plot(Plant_Data.Time,Plant_Data.Data(:,4))
% plotyy(Plant_Data.Time,Plant_Data.Data(:,5),Plant_Data.Time,Plant_Data.Data(:,4))
% title('Flow Rates')
% % hold on
% % plot(Plant_Data.Time,Plant_Data.Data(:,5))
% legend('Air Flow','Fuel Flow')
% %xlim([0 xmax])
% %set(gca, 'XTickLabel', []);
% 
% subplot(4,1,4)
% plot(Plant_Data.Time,Plant_Data.Data(:,1))
% title('IGV Angle')
% legend('IGV Angle')
% %xlim([0 xmax])
% 
% 
% % Plot plant data in a single plot
% figure
% plot(Plant_Data)
% title('Plant Data')
% legend('IGV Angle','T_Solar','T_Storage','Fuel Flow','Air Flow',...
%     'Firing T','Exhaust T','Turbine','Steam Turbine');

% Plot Total Power against power set-point
figure 
subplot(2,1,1)
plot(Plant_Data.Time,Plant_Data.Data(:,8)+Plant_Data.Data(:,9))
hold on
plot(Power_Set_Point)
title('Total Power (MW)')
legend('Power','Setpoint','Location','southeast')
xlabel('')
ylabel('')

subplot(2,1,2)
plot(Plant_Data.Time,Plant_Data.Data(:,11))
title('Solar Radiation (W/m^2)')
xlabel('Time (minutes)')
