% ******************************************
% Derivatives
% ******************************************


function [dxdt] = tank(u)


% Inputs

m_out1 = u(1); % 
m_in2 = u(2); % 

% States
%p_inter = x(1);%


% Parameters
SpeedSound = 340;     % speed of sound
VolumeTinter = 1e-2; % volume of middle tank


% these are the differential equations
dxdt(1) = SpeedSound/VolumeTinter*(m_out1 - m_in2); % sys(1) is dPinter/dt