function msg = mpc_init(s,a)

% -------------------------------------------
% Setting up APMonitor and initializing the controller
% -------------------------------------------

% Add path to APM libraries
addpath('apm');

% Clear previous application
apm(s,a,'clear all');

% load model variables and equations
apm_load(s,a,'mpc.apm');

% load data
csv_load(s,a,'mpc.csv');

%  APM Variable Classification
apm_info(s,a,'MV','torq[1]');
apm_info(s,a,'MV','torq[2]');
apm_info(s,a,'CV','flow1');
apm_info(s,a,'CV','p_out1');
apm_info(s,a,'CV','flow2');
apm_info(s,a,'CV','p_out2');
apm_info(s,a,'CV','presstank');

% Options
apm_option(s,a,'nlc.imode',6);
apm_option(s,a,'nlc.nodes',4);
apm_option(s,a,'nlc.solver',1);
apm_option(s,a,'nlc.cv_type',1);
apm_option(s,a,'nlc.web_plot_freq',1);
apm_option(s,a,'nlc.ctrl_units',1);
apm_option(s,a,'nlc.hist_hor',500);
%apm_option(s,a,'nlc.sensitivity',1);

% Bounds
apm_option(s,a,'torq[1].lower',-5);
apm_option(s,a,'torq[2].lower',-5);
apm_option(s,a,'torq[1].upper',5);
apm_option(s,a,'torq[2].upper',5);

% Turn on parameters to control
apm_option(s,a,'torq[1].status',1);
apm_option(s,a,'torq[2].status',1);
apm_option(s,a,'p_out1.status',1);
apm_option(s,a,'p_out2.status',1);

%Turn on feedback status for CVs
apm_option(s,a,'flow1.fstatus',0);
apm_option(s,a,'flow2.fstatus',0);
apm_option(s,a,'p_out1.fstatus',1);
apm_option(s,a,'p_out2.fstatus',1);
apm_option(s,a,'presstank.fstatus',0);
apm_option(s,a,'torq[1].fstatus',0);
apm_option(s,a,'torq[2].fstatus',0);

%settings for the set point trajectory (0=deadband)
apm_option(s,a,'p_out1.tr_init',2);
apm_option(s,a,'p_out2.tr_init',2);

%Tuning constraints
apm_option(s,a,'torq[1].dmax',0.1);
apm_option(s,a,'torq[2].dmax',0.1);
apm_option(s,a,'torq[1].dcost',0.01);
apm_option(s,a,'torq[2].dcost',0.01);


return