function output = mpc_(inputs)

persistent s a icount


if (isempty(icount)),
    % Select server and application name
    s = 'http://byu.apmonitor.com';
    
    a = 'controller';
    % Initialize MPC controller
    mpc_init(s,a)
    % Initialize counter
    icount = 0;
    % first cycle, set torque to initial values
    torqy1 = 0;
    torqy2 = 0;
    
else
    icount = icount + 1;
    % process inputs
    
    %%%%%FLOW INPUTS%%%%%    
%    m1sp = inputs(1);
%    m1_meas = inputs(2);
%    m2sp = inputs(3);
%    m2_meas = inputs(4);
    
    %%%%%PRESSURE INPUTS%%%%%
    p1sp = inputs(1);
    p1_meas = inputs(2);
    p2sp = inputs(3);
    p2_meas = inputs(4); 
    
    %Input setpoint and measurements
    
    %%%%%FLOW SETPOINTS%%%%%
%    apm_option(s,a,'flow1.sphi',m1sp+0.01);
%    apm_option(s,a,'flow1.splo',m1sp-0.01);
%    apm_meas(s,a,'flow1',m1_meas);
%    apm_option(s,a,'flow2.sphi',m2sp+0.01);
%    apm_option(s,a,'flow2.splo',m2sp-0.01);
%    apm_meas(s,a,'flow2',m2_meas);

    %%%%%PRESSURE SETPOINTS%%%%%
    apm_option(s,a,'p_out1.sphi',p1sp+10);
    apm_option(s,a,'p_out1.splo',p1sp-10);
    apm_meas(s,a,'p_out1',p1_meas);
    apm_option(s,a,'p_out2.sphi',p2sp+10);
    apm_option(s,a,'p_out2.splo',p2sp-10);
    apm_meas(s,a,'p_out2',p2_meas);
    % Solve
    out = apm(s,a,'solve');
    disp(out)
    
    % Output parameters, check if good solution
    if (apm_tag(s,a,'nlc.appstatus')==1),
        torqy1 = apm_tag(s,a,'torq[1].newval');
        torqy2 = apm_tag(s,a,'torq[2].newval');
    else
        torqy1 = 0;
        torqy2 = 0;
    end
end


if isnan(torqy1)
    % protect outputs against bad solutions
    output(1) = 0;
elseif isnan(torqy2)
    output(2) = 0;
else
    output(1) = torqy1;
    output(2) = torqy2;
end

if (icount==5),
    % open web-viewer
    apm_web(s,a);
end

return