function [sys,x0,str,tss]=inter_tank(t,x,u,flag,Param,X_ss) %left side is outputs, right side is inputs
switch flag,

case 0,	% Initialize the states and sizes
   [sys,x0,str,tss] = mdlInitialSizes(t,x,u,X_ss);
   
    % ****************
  	%  Outputs
  	% ****************   
     
case 3,   % Calculate the outputs
   
   sys = mdlOutputs(t,x,u,Param);
   
   % ****************
   % Update
   % ****************
case 1,	% Obtain derivatives of states

   sys = mdlDerivatives(t,x,u,Param);

otherwise,
   sys = [];
end

% ******************************************
% Sub-routines or Functions
% ******************************************

% ******************************************
% Initialization
% ******************************************

function [sys,x0,str,tss] = mdlInitialSizes(t,x,u,X_ss);



% This handles initialization of the function.
% Call simsize of a sizes structure.
sizes = simsizes;
sizes.NumContStates  = 1;     % continuous states - how many states the model has
sizes.NumDiscStates  = 0;     % discrete states
sizes.NumOutputs     = 1;     % outputs of model - how many actual lines we'll have coming out 
sizes.NumInputs      = 2;     % inputs of model
sizes.DirFeedthrough = 1;     % System is causal
sizes.NumSampleTimes = 1;     %
sys = simsizes(sizes);        %
x0  = X_ss;                   % Initialize the states 


str = [];	                  % set str to an empty matrix.
tss = [0,0];	              % sample time: [period, offset].

% ******************************************
%  Outputs
% ******************************************

function [sys] = mdlOutputs(t,x,u,Param);


% Inputs
m_out1 = u(1); % 
m_in2 = u(2); % 

% States
p_inter = x(1);%


sys(1) = x(1); % p_inter

% ******************************************
% Derivatives
% ******************************************


function sys = mdlDerivatives(t,x,u,Param)


% Inputs

m_out1 = u(1); % 
m_in2 = u(2); % 

% States
p_inter = x(1);%


% Parameters
SpeedSound = 340;     % speed of sound
VolumeTinter = 1e-2; % volume of middle tank


% these are the differential equations
sys(1) = SpeedSound/VolumeTinter*(m_out1 - m_in2); % sys(1) is dPinter/dt


