function [sys,x00,str,tss]=comp_plant2(t,x,u,flag,Param,X_ss2) %left side is outputs, right side is inputs
switch flag,

case 0,	% Initialize the states and sizes
   [sys,x00,str,tss] = mdlInitialSizes(t,x,u,X_ss2);
   
    % ****************
  	%  Outputs
  	% ****************   
     
case 3,   % Calculate the outputs
   
   sys = mdlOutputs(t,x,u,Param);
   
   % ****************
   % Update
   % ****************
case 1,	% Obtain derivatives of states

   sys = mdlDerivatives(t,x,u,Param);

otherwise,
   sys = [];
end

% ******************************************
% Sub-routines or Functions
% ******************************************

% ******************************************
% Initialization
% ******************************************

function [sys,x00,str,tss] = mdlInitialSizes(t,x,u,X_ss2);



% This handles initialization of the function.
% Call simsize of a sizes structure.
sizes = simsizes;
sizes.NumContStates  = 6;     % continuous states
sizes.NumDiscStates  = 0;     % discrete states
sizes.NumOutputs     = 8;     % outputs of model 
sizes.NumInputs      = 5;     % inputs of model
sizes.DirFeedthrough = 1;     % System is causal
sizes.NumSampleTimes = 1;     %
sys = simsizes(sizes);        %
x00  = X_ss2;                   % Initialize the states 


str = [];	                  % set str to an empty matrix.
tss = [0,0];	              % sample time: [period, offset].

% ******************************************
%  Outputs
% ******************************************

function [sys] = mdlOutputs(t,x,u,Param);



% these relate valve opening to pressure/flow rate
Valve_in_gain = 1/(sqrt(1.05e5-1e5));   % opening gain
Valve_rec_gain = 1/(sqrt(1.2891e5-1e5)); % opening gain
Valve_out_gain = 1/(sqrt(1.2891e5-1.2e5)); % opening gain

% Inputs

torque_drive = u(1); % 
Inflow_opening = u(2); % 
Outflow_opening = u(3); % 
Recycle_opening = u(4); % 
In_pres = u(5); 


% States

p1 = x(1);%
p2 = x(2);%
m_comp = x(3);%
p_ratio = x(4);%
omega_comp = x(5);%
m_rec = x(6);%

% Parameters

SpeedSound = 340;     % speed of sound
Out_pres   = 2.05e5; % output pressure

Valve_in_gain = 1/(sqrt(1.05e5-1e5));   % opening gain
Valve_rec_gain = 1/(sqrt(1.2891e5-1e5)); % opening gain
Valve_out_gain = 1/(sqrt(1.2891e5-1.2e5)); % opening gain


m_in = Valve_in_gain*Inflow_opening*sqrt(abs(In_pres - p1))*(In_pres - p1)/abs(In_pres - p1);% Inflow valve
m_out = Valve_out_gain*Outflow_opening*sqrt(abs(p2 - Out_pres))*(p2 - Out_pres)/abs(p2 - Out_pres);% Outflow valve
m_out = max(m_out, 0);
m_rec_ss = Valve_rec_gain*Recycle_opening*sqrt(abs(p2 - p1))*(p2 - p1)/abs(p2 - p1);% Recycle valve



surge_d = 100;
% first five are the states, the outputs
% 6-8 are the mass flows (what they should be)
sys(1) = x(1); % p1
sys(2) = x(2); % p2
sys(3) = x(3); % m_comp 
sys(4) = x(4); % p_ratio
sys(5) = x(5); % omega_comp
sys(6) = m_in; % 
sys(7) = m_out; % 
sys(8) = m_rec; % 
% ******************************************
% Derivatives
% ******************************************


function sys = mdlDerivatives(t,x,u,Param)


% Inputs

torque_drive = u(1); % 
Inflow_opening = u(2); % 
Outflow_opening = u(3); % 
Recycle_opening = u(4); % 
In_pres = u(5);


% States

p1 = x(1);%
p2 = x(2);%
m_comp = x(3);%
p_ratio = x(4);%
omega_comp = x(5);%
m_rec = x(6);%

% Parameters

SpeedSound = 340;     % speed of sound
Out_pres   = 2.05e5; % output pressure

Valve_in_gain = 1/(sqrt(1.05e5-1e5));   % opening gain
Valve_rec_gain = 1/(sqrt(1.2891e5-1e5)); % opening gain
Valve_out_gain = 1/(sqrt(1.2891e5-1.2e5)); % opening gain

VolumeT1 = 1e-2; % volume
VolumeT2 = 1e-3; % volume
AdivL = 0.2e-3;  % Duct cross section divided by length

%%% Compressor
Dt         = 0.18;  % impeller diameter
sigma_slip = 0.9;   % compressor slip
J          = 0.01;  % shaft inertia 
tauComp    = 8;     % time constant of the pressure ratio
tauRecycle = 1;     % time constant of the recycle valve

%%% coefficients of the compressor map %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C0 =[0.000000000061147  -0.000000603072143   0.002205681837355   -1.461782281888261];
C1 =[-0.000000000882663   0.000008394635394  -0.026129863772614    25.840599079312330];
C2 =1.4*[0.000000001205096  -0.000008916645219   0.018455555634821   -1.277068107070351 ];
C3 =[0.0000000150689  -0.0001472249440   0.4791436514340  -529.0322734770704 ];




% Algebraic equations

% valves
m_in = Valve_in_gain*Inflow_opening*sqrt(abs(In_pres - p1))*(In_pres - p1)/abs(In_pres - p1);% Inflow valve mass flow rate (qs in paper)
m_out = Valve_out_gain*Outflow_opening*sqrt(abs(p2 - Out_pres))*(p2 - Out_pres)/abs(p2 - Out_pres);% Outflow valve mass flow rate (qd in paper)
m_out = max(m_out, 0); %ensures that m_out is never negative
m_rec_ss = Valve_rec_gain*Recycle_opening*sqrt(abs(p2 - p1))*(p2 - p1)/abs(p2 - p1);% Recycle valve mass flow rate (qr in paper)

% these construct the compressor map
% compressor pressure ratio
omega_compp = omega_comp*0.72;
A0=C0(4)+C0(3)*omega_compp+C0(2)*omega_compp^2+C0(1)*omega_compp^3;
A1=C1(4)+C1(3)*omega_compp+C1(2)*omega_compp^2+C1(1)*omega_compp^3;
A2=C2(4)+C2(3)*omega_compp+C2(2)*omega_compp^2+C2(1)*omega_compp^3;
A3=C3(4)+C3(3)*omega_compp+C3(2)*omega_compp^2+C3(1)*omega_compp^3;

p_ratio_ss=A0+A1*m_comp+A2*m_comp^2+A3*m_comp^3;

% compressor pressure
p_comp = p_ratio*p1;

% compressor torque
torque_comp = sigma_slip*(Dt/2)^2*omega_comp*abs(m_comp);

% these are the differential equations
sys(1) = SpeedSound/VolumeT1*(m_in + m_rec - m_comp) ; % 
sys(2) = SpeedSound/VolumeT2*(m_comp - m_rec - m_out) ; % 
sys(3) = AdivL*(p_comp-p2); %
sys(4) = tauComp*(p_ratio_ss-p_ratio); % 
sys(5) = 1/J*(torque_drive-torque_comp); %
sys(6) = tauRecycle*(m_rec_ss - m_rec);%

