from apm import *
from scipy.optimize import minimize
import numpy as np
import  matplotlib.pyplot as plt


def func(guess, web=False):
    s = 'http://byu.apmonitor.com'
    a = 'cond_example2'

    apm(s, a, 'clear all')

    apm_load(s, a, 'model.apm')
    csv_load(s, a, 'time.csv')

    apm_option(s, a, 'nlc.imode', 4)
    apm_option(s, a, 'nlc.nodes', 2)
    apm_option(s, a, 'nlc.solver', 1)

    apm_info(s, a, 'FV', 'tswitch')
    apm_meas(s, a, 'tswitch', guess)

    output = apm(s, a, 'solve')
    # print output

    if web:
        apm_web(s, a)

    y = apm_sol(s, a)
    return y['y'][-1]

inputs = np.linspace(0, 2, 100)
outputs = np.empty(inputs.size)

for i in range(inputs.size):
    outputs[i] = func(inputs[i])

plt.figure()
plt.plot(inputs, outputs)
plt.show()
