# -*- coding: utf-8 -*-
"""
Created on Mon Apr  4 18:17:09 2016

@author: jacksonudy
"""

import numpy as np
from CRM import *
import matplotlib.pyplot as plt
import pandas

# Choose server app and model files and size of field
s = 'http://byu.apmonitor.com'
a = 'scheme' + str(np.random.randint(0,1000))
#==============================================================================
# Two Injector Field
#==============================================================================
#datafile = 'scheme2deviation67.csv'
#CRM_Model = 'crm.apm'
##datafile = 'scheme2noisedev.csv' # Uncomment for noisy data
#numInj = 2
#numProd = 2
#==============================================================================
# Four Injector Field
#==============================================================================
CRM_Model = 'CRM4x4.apm'
datafile = '4x4deviation.csv'
numInj = 4
numProd = 4

#==============================================================================
# Eight Injector Field
#==============================================================================
#CRM_Model = 'crm8x8.apm'
#datafile = '8x8deviation67.csv'
#numInj = 8
#numProd = 8

#==============================================================================
# 
#==============================================================================

# 62.69 42.96	21.83	46.86	73.78	56.54	72.55	79.68
















" ----------------------------------------------------------------------------------- "
" ------------- Adjust these to make sure they grab the right data ------------------ "
" ----------------------------------------------------------------------------------- "
# Grab data to plot comparision  
data = pandas.read_csv(datafile)
time = data.ix[:,0]
production1 = data.ix[:,7]
production2 = data.ix[:,8]
# Total Production from each well
#production1 = data.ix[:,25]
#production2 = data.ix[:,26]
#production3 = data.ix[:,27]
#production4 = data.ix[:,28]
#production5 = data.ix[:,29]
#production6 = data.ix[:,30]
#production7 = data.ix[:,31]
#production8 = data.ix[:,32]
#prod3oildata = data.ix[:,7]
# etc, etc, etc
production = [0,production1,production2]#,production3,production4,production5,production6,production7,production8]

" ----------------------------------------------------------------------------------- "
" ----------------------------------------------------------------------------------- "

#==============================================================================
# CRM Model Parameter Estimation
#==============================================================================

x = CRM_Parameter_Est(s,a,numInj,numProd,datafile,CRM_Model)
CRM_Parameters = x[0]
output = x[1]
infeasabilities = x[2]
print output

nondev = [0,307,184]
#nondev = [0,271,184,91.5,203]
#nondev = [0,62.69,42.96,21.83,46.86,73.78,56.54,72.55,79.68]
gain = np.zeros([numInj + 1,numProd + 1])
tau  = np.zeros([numInj + 1,numProd + 1])
for i in range(1, numInj + 1):
    for j in range(1, numProd + 1):
        var = 'gain' + str(i) + str(j)
        gain[i,j] = CRM_Parameters[var][1] 
        print var + ': ' + str(gain[i,j])
        var = 'tau' + str(i) + str(j)
        tau[i,j] = CRM_Parameters[var][1]
        print var + ': ' + str(tau[i,j])

q = [0]
for i in range(1, numProd + 1):
    q.append(CRM_Parameters['q' + str(i)])


# Plotting 
for i in range(1, numProd + 1):
    plt.figure(i)
    for j in range(0,len(production[i])):
        production[i][j] = production[i][j] + nondev[i]
        q[i][j] = q[i][j] + nondev[i]
    #plt.clf()
    plt.plot(time,production[i],'ro')
    plt.plot(time,q[i])
    plt.legend(['Data','Model'])
    plt.title('Well ' + str(i) + ' Total Production')
    plt.ylabel('BPD')
    plt.xlabel('Days')
    plt.savefig('8x8Prod' + str(i))


#plt.figure(5)
#plt.plot(time,CRM_Parameters['q11'],linewidth = 3)
#plt.legend(['Model'])
##plt.title('')
#plt.ylabel('BPD')
#plt.xlabel('Days')
#plt.savefig('q11.png')
#
#plt.figure(6)
#plt.plot(time,CRM_Parameters['q12'],linewidth = 3)
#plt.legend(['Model'])
#plt.ylabel('BPD')
#plt.xlabel('Days')
#plt.savefig('q12.png')
#
#plt.figure(7)
#plt.plot(time,CRM_Parameters['q21'],linewidth = 3)
#plt.legend(['Model'])
#plt.ylabel('BPD')
#plt.xlabel('Days')
#plt.savefig('q21.png')
#
#plt.figure(8)
#plt.plot(time,CRM_Parameters['q22'],linewidth = 3)
#plt.legend(['Model'])
#
#plt.ylabel('BPD')
#plt.xlabel('Days')
#plt.savefig('q22.png')


#==============================================================================
# Optimization of Injection
#==============================================================================
#try:    
#    Optimal_Solution = Optimize_CRM(s,a,datafile,model,numInj,numProd)
#    
#    Inj = [0]
#    for i in range(1, numInj + 1):
#        inject = Optimal_Solution['inj' + str(i)]
#        Inj.append(inject)
#    Optimal_Total_Production = [0]
#    Optimal_Oil_Production = [0]
#    for i in range(1, numProd + 1):
#        Product = Optimal_Solution['q' + str(i)]
#        Optimal_Total_Production.append(Product)
#        Oil = Optimal_Solution['prod' + str(i) + 'oil']
#        Optimal_Oil_Production.append(Oil)
#
#except:
#    print " ----------------------------------------------------------------------------------- "
#    print " -------------------------- Error in Optimization ---------------------------------- "
#    print " ----------------------------------------------------------------------------------- " 









        
    