# -*- coding: utf-8 -*-
"""
Created on Mon Apr  4 23:14:33 2016

@author: jacksonudy
"""
from apm import *

# Call these functions
#==============================================================================
# CRM Model Parameter Estimation 
#==============================================================================
def CRM_Parameter_Est(s, a, numInj ,numProd ,datafile, model):
    
    apm(s,a,'clear all')
    apm_load(s,a,model)
    csv_load(s,a,datafile)
    
    # Set Global Options 
    apm_option(s,a,'nlc.imode',5)   # Choosing the problem type, Estimation (MHE)
    apm_option(s,a,'nlc.nodes',2)   # Number of collocation nodes between time points.
    apm_option(s,a,'nlc.solver',3)  # Choose the solver 
    apm_option(s,a,'nlc.ev_type',2) # ev_type = 1 (L1-norm) or 2 (squared error)   
    apm_option(s,a,'nlc.sensitivity',1) # Sensitivity Analysis 
    apm_option(s,a,'nlc.max_iter',250)
    
    for i in range(1,numInj + 1):
        for j in range(1, numProd + 1):
            gain = 'gain' + str(i) + str(j)
            apm_info(s,a,'FV',gain)
            apm_option(s,a,gain + '.status',1)
            apm_option(s,a,gain + '.lower',0)
            apm_option(s,a,gain + '.upper',1)
            apm_option(s,a,gain + '.upper',1)
            apm_option(s,a,gain + '.wmodel',0) # Weight Model Values to 0
            
            # Set constraints for each time constant and turn status on        
            tau = 'tau' + str(i) + str(j)
            apm_info(s,a,'FV',tau)
            apm_option(s,a,tau + '.status',1)
            apm_option(s,a,tau + '.lower',0.001)
            apm_option(s,a,tau + '.upper',500)
            apm_option(s,a,tau + '.wmodel',0) # Weight Model Values to 0
            
            # State Variables
            q = 'q' + str(i) + str(j)
            apm_info(s,a,'SV',q)
      
    # Set up Injectors      
    for i in range(1,numInj + 1):
        ref = 'Inj' + str(i)
        apm_info(s,a,'SV',ref)
        apm_option(s,a,ref + '.status',0)
    
    # Set up Producers
    for i in range(1,numProd + 1):
        ref = 'q' + str(i)
        apm_info(s,a,'CV',ref)
        apm_option(s,a,ref + '.fstatus',1)
    
    # solve
    output = apm(s,a,'solve')
    print ""
    print ""
    print "-----------------------------------------------------"
    print "------------- CRM Parameter Estimation --------------"
    print "-----------------------------------------------------"
    print ""
    print output
    
    # retrieve solution
    z = apm_sol(s,a)
    #
    ## Open Web Browser
    apm_web(s,a)
    
    infeasabilities = apm_get(s,a,'infeasibilities.txt')
    
    return (z,output,infeasabilities)
    
#==============================================================================
# FFM Parameter Estimation 
#==============================================================================
def FFM_Parameter_Est(s,a,datafile,model,numProd,numInj):
    # Load APM File for FFM 
    a2 = a
    apm(s,a2,'clear all')
    apm_load(s,a2,model)
    csv_load(s,a2,datafile)
    
    # Global Options
    apm_option(s,a2,'nlc.imode',5)   # Select the problem type, Estimation (MHE) = 5
    apm_option(s,a2,'nlc.nodes',2)   # Number of collocation nodes between time points.
    apm_option(s,a2,'nlc.solver',3)  # Choose the solver (IPOPT I think)
    apm_option(s,a2,'nlc.ev_type',1) # ev_type = 1 (L1-norm) or 2 (squared error)
    apm_option(s,a2,'nlc.sensitivity',1)
    #apm_option(s,a2,'nlc.max_iter',50)

    apm_info(s,a2,'SV','CWI')
    apm_option(s,a2,'CWI.fstatus',1)
    
    for i in range(1, numProd + 1):
        # Set constraints for each a parameter and turn status on   
        parametera = 'lna[' + str(i) + ']'
        apm_info(s,a2,'FV',parametera)
        apm_option(s,a2,parametera + '.status',1)
        apm_option(s,a2,parametera + '.wmodel',0.0)    # Weight Model Values to 0
        #apm_option(s,a2,parametera + '.lower',-22)
        #apm_option(s,a2,parametera + '.upper',-18)
            
        # Set constraints for each b parameter and turn status on        
        parameterb = 'b[' + str(i) + ']'
        apm_info(s,a2,'FV',parameterb)
        apm_option(s,a2,parameterb + '.status',1)
        apm_option(s,a2,parameterb + '.lower',0)
        #apm_option(s,a2,parameterb + '.upper',2)
        apm_option(s,a2,parameterb + '.wmodel',0)     # Weight Model Values to 0
        
        # Show State Variables
        apm_info(s,a2,'SV','prod' + str(i) + 'water')
        apm_info(s,a2,'SV','q' + str(i))
        
        # Set up CV's
        ref = 'prod' + str(i) + 'oil'    
        apm_info(s,a2,'CV',ref)
        apm_option(s,a2,ref + '.status',1)
        apm_option(s,a2,ref + '.fstatus',1)
        apm_option(s,a2,ref + '.wmodel',0.0) 
        
    for i in range(1, numInj +1):
        var = 'inj' + str(i)
        apm_info(s,a2,'SV',var)
        apm_option(s,a2,var + '.fstatus',0)
        
    apm_option(s,a2,'nlc.coldstart',1)
    output = apm(s,a2,'solve')
    
    apm_option(s,a2,'nlc.coldstart',0)
    output = apm(s,a2,'solve')
    
    print ""
    print ""
    print ""
    print "-----------------------------------------------------"
    print "---- Fractional Flow Model Parameter Estimation -----"
    print "-----------------------------------------------------"
    print ""
    print output
    
    ## retrieve solution
    z = apm_sol(s,a2)
    
    # Open Web Browser
    apm_web(s,a2)
    
    return (z, output)
 
def Optimize_CRM(s,a,datafile,model,numInj,numProd):  
    # Problem Setup
    apm(s,a,'clear all')
    apm_load(s,a,model)
    csv_load(s,a,datafile)
    # Global settings
    apm_option(s,a,'nlc.imode',6)      # Solve mode (6 = Optimization, 4 = Simulation)
    apm_option(s,a,'nlc.nodes',3)      # Number of collocation nodes
    apm_option(s,a,'nlc.solver',1)     # Solver: Try IPOPT later (3)
    #apm_option(s,a,'nlc.max_iter', 20)   # Attempt to solve quicker at the expense of solution optimality
    
    # controller setup
    apm_info(s,a,'SV','CWI')    
    apm_info(s,a,'CV','TotalProduction')
    
    for i in range(1, numProd + 1):
        var = 'q' + str(i)
        apm_info(s,a,'SV',var)              # Set up qi
        var = 'prod' + str(i) + 'water'      
        apm_info(s,a,'SV',var)              # Set up prodiwater
        var = 'prod' + str(i) + 'oil'  
        apm_info(s,a,'SV',var)              # Set up prodioil
    
    for i in range (1, numInj + 1):
        var = 'inj' + str(i)
        apm_info(s,a,'MV',var)              # Set up inji
        apm_option(s,a,var + '.status',1)   # Turn status on for optimizer to adjust
        apm_option(s,a,var + '.lower',0)    # Lower constraint
    
    for i in range(1, numInj + 1):          # First is injector second is producer
        for j in range(1, numProd + 1):
            var = 'q' + str(i) + str(j)
            apm_info(s,a,'SV',var)
            
    solution = apm(s,a,'solve')
    print solution
    
    # retrieve solution
    z = apm_sol(s,a)
    
    # open web viewer
    apm_web(s,a)

    return z        

    # manipulated variables
#    apm_info(s,a,'MV','inj1')
#    apm_info(s,a,'MV','inj2')
#    apm_option(s,a,'inj1.status',1)
#    apm_option(s,a,'inj2.status',1)
    
    # State Variable Declaration
#    apm_info(s,a,'SV','q11')
#    apm_info(s,a,'SV','q12')
#    apm_info(s,a,'SV','q21')
#    apm_info(s,a,'SV','q22')
    #apm_info(s,a,'SV','q1')
    #apm_info(s,a,'SV','q2')
    #apm_info(s,a,'SV','prod1water')
    #apm_info(s,a,'SV','prod2water')
    
    #apm_info(s,a,'SV','prod1oil')
    #apm_info(s,a,'SV','prod2oil')
    
    # controlled variables
#    apm_info(s,a,'CV','TotalProduction')
    #apm_option(s,a,'product.status',1)
    #apm_option(s,a,'product.fstatus',1)
    
    ## MV tuning
    # lower and upper bounds for MV's
#    apm_option(s,a,'inj1.lower',0)
#    apm_option(s,a,'inj2.lower',0)
    
    # solve
