#!/usr/bin/env python
from apm import *  # load APMonitor.com toolkit
import numpy as np
s = "http://byu.apmonitor.com"
a = 'Daniel'
apm(s,a,'clear all')
apm_load(s,a,'dip.apm')
csv_load(s,a,'dip2.csv')
apm_option(s,a,'nlc.imode',7)
apm_option(s,a,'nlc.solver',3)
apm_option(s,a,'nlc.nodes',2)
apm(s,a,'solve')

print("solving")
z = apm_sol(s,a)
# print z

# z = apm_solve('dip',7)
print("done solving")

# plot results
import matplotlib.pyplot as plt

plt.figure(1)
plt.suptitle("Simulation Results")
plt.subplot(211)
plt.plot(z["time"],z["x1"],'b-')
plt.xlabel('Time (s)')
plt.ylabel('x-position (m)')
plt.legend(['Cart Position'])

# plt.subplot(312)
# plt.plot(z["time"],z["th1"],'b--')
# plt.plot(z["time"],z["th2"],'r--')
# plt.legend(['th1','th2'])
# plt.ylabel('Thetas (rad)')
# plt.xlabel('Time (s)')

plt.subplot(212)
# plt.plot(z["time"],z["th1"],'b--')
# plt.plot(z["time"],z["th2"],'r--')
plt.plot(z["time"],z["th1adj"],'g-')
plt.plot(z["time"],z["th2adj"],'k-')
# plt.plot(z['time'],z['th1.tr_hi'],'k-')
# plt.plot(z['time'],z['th2.tr_lo'],'k-')
plt.xlabel('Time (s)')
plt.ylabel('Thetas in Degrees')
plt.legend(['th1','th2','th1adj','th2adj'])

plt.show()
