#!/usr/bin/env python
from apm import *  # load APMonitor.com toolkit
import numpy as np


#Simulator
s = "http://byu.apmonitor.com"
a = 'simulator'
apm(s,a,'clear all')
apm_load(s,a,'dip.apm')
csv_load(s,a,'dip_step.csv')

#Parameters
FVs = '---','---'
MVs = 'F','---'
#Variables
SVs = '---'
CVs = 'x1','th1','th2','ojth1','ojth2'
# CVs = 'x1','th1','th2'
# Set up variable classifications for data flow
for x in FVs: apm_info(s,a,'FV',x)
for x in MVs: apm_info(s,a,'MV',x)
for x in SVs: apm_info(s,a,'SV',x)
for x in CVs: apm_info(s,a,'CV',x)
# Options
# turn on historization to see past results in web-viewer
apm_option(s,a,'nlc.hist_hor',100)
# set web plot update frequency
apm_option(s,a,'nlc.web_plot_freq',3)
# set number of nodes for collocation
apm_option(s,a,'nlc.nodes',5)
# imode (1=ss, 2=mpu, 3=rto, 4=sim, 5=mhe, 6=nlc)
# initialize with steady state
apm_option(s,a,'nlc.solver',3)
apm_option(s,a,'nlc.imode',4)
apm_option(s,a,'nlc.max_iter',200)
solver_output = apm(s,a,'solve')


# Controller
c = 'mpc'
apm(s,c,'clear all')
apm_load(s,c,'mpc.apm')
csv_load(s,c,'mpc.csv')

apm_info(s,c,'MV','F')
apm_info(s,c,'CV','th1')
apm_info(s,c,'CV','th2')
apm_info(s,c,'CV','x1')
apm_info(s,c,'CV','ojth1')
apm_info(s,c,'CV','ojth2')

apm_info(s,c,'FV','p1')
apm_info(s,c,'FV','p2')

apm_option(s,c,'nlc.imode',6) #ctrl mode
apm_option(s,c,'nlc.nodes',3)
apm_option(s,c,'nlc.max_iter',200)
apm_option(s,c,'nlc.cv_type',1)
apm_option(s,c,'nlc.mv_type',1)
apm_option(s,c,'nlc.sensitivity',1)
apm_option(s,c,'nlc.web_plot_freq',2)
# apm_option(s,c,'nlc.time_shift',1)

# lower and upper bounds Force
apm_option(s,c,'F.mv_step_hor',2)
apm_option(s,c,'F.lower',-500)
apm_option(s,c,'F.upper',500)
apm_option(s,c,'F.status',1)
apm_option(s,c,'F.fstatus',0)
apm_option(s,c,'F.dcost',1e-5)
apm_option(s,c,'F.cost',0)

#Th1
apm_option(s,c,'th1.status',0)
apm_option(s,c,'th1.fstatus',0)
# apm_option(s,c,'th1.wmeas',100)
# apm_option(s,c,'th1.wmodel',0)

# th1sp = 180*np.pi/180
# apm_option(s,c,'th1.sphi',th1sp+.001)
# apm_option(s,c,'th1.splo',th1sp-.001)
# apm_option(s,c,'th1.sp',th1sp)
# apm_option(s,c,'th1.tr_init',0)
# apm_option(s,c,'th1.wsphi',0)
# apm_option(s,c,'th1.wsplo',0)

#Th2
apm_option(s,c,'th2.status',0)
apm_option(s,c,'th2.fstatus',0)
# apm_option(s,c,'th2.tr_init',0)
# apm_option(s,c,'th2.wmeas',100)
# apm_option(s,c,'th2.wmodel',0)

# th2sp = 180*np.pi/180
# apm_option(s,c,'th2.sphi',th2sp+.01)
# apm_option(s,c,'th2.splo',th2sp-.01)

#X1
apm_option(s,c,'x1.status',0)
apm_option(s,c,'x1.fstatus',0)
# xsp = 0
# apm_option(s,c,'x1.sp',0)
# apm_option(s,c,'x1.sphi',xsp+.1)
# apm_option(s,c,'x1.splo',xsp-.1)
# apm_option(s,c,'x1.wsp',.001)
# apm_option(s,c,'x1.wsphi',.001)
# apm_option(s,c,'x1.wsplo',.001)
# apm_option(s,c,'x1.tr_init',0)

#ojth1
apm_option(s,c,'ojth1.status',1)
apm_option(s,c,'ojth1.fstatus',0)
ojth1sp = 0
apm_option(s,c,'ojth1.sp',0)
apm_option(s,c,'ojth1.sphi',ojth1sp+.001)
apm_option(s,c,'ojth1.splo',ojth1sp-.001)
apm_option(s,c,'ojth1.wsphi',100)
apm_option(s,c,'ojth1.wsplo',100)
apm_option(s,c,'ojth1.wsp',100)
apm_option(s,c,'ojth1.tr_init',0)

# #ojth2
apm_option(s,c,'ojth2.status',1)
apm_option(s,c,'ojth2.fstatus',0)
ojth2sp = 0
apm_option(s,c,'ojth2.sp',0)
apm_option(s,c,'ojth2.sphi',ojth2sp+.001)
apm_option(s,c,'ojth2.splo',ojth2sp-.001)
apm_option(s,c,'ojth2.wsphi',100)
apm_option(s,c,'ojth2.wsplo',100)
apm_option(s,c,'ojth2.wsp',100)
apm_option(s,c,'ojth2.tr_init',0)

#Disturbances
apm_option(s,c,'p1.status',0)
apm_option(s,c,'p1.fstatus',0)
apm_option(s,c,'p2.status',0)
apm_option(s,c,'p2.fstatus',0)

time = 0
dt = .01

x1 = 0
th1 = 5*np.pi/180
th2 = 5*np.pi/180
ojth1 = 1+np.cos(th1)
ojth2 = 1+np.cos(th2)

th1_tracker = np.array([])
th2_tracker = np.array([])
x1_tracker = np.array([])
oj_tracker = np.array([])
ojth1_tracker = np.array([])
ojth2_tracker = np.array([])

F_tracker = np.array([])
time_tracker = np.array([])

default_solver = 3
nondefault = 1
F = 0
p1 = 0
p2 = 0

for isim in range(200): # if abs(ojth1-ojth1sp) < .01:
    #     apm_option(s,c,'nlc.coldstart',1);


    apm_option(s,c,'nlc.solver',default_solver);
    # apm_meas(s,c,'th1',th1)
    # apm_meas(s,c,'th2',th2)
    # apm_meas(s,c,'x1',x1)
    # apm_meas(s,c,'ojth1',ojth1)
    # apm_meas(s,c,'ojth2',ojth2)
    # apm_meas(s,c,'p1',p1)
    # apm_meas(s,c,'p2',p2)

    #solve
    output = apm(s,c,'solve');
    d = apm_sol(s,c)

    #Output MV new value
    if (apm_tag(s,c,'nlc.appstatus')==1):
        F = apm_tag(s,c,'F.newval');
        th1_c = apm_tag(s,c,'th1.model');
        th2_c = apm_tag(s,c,'th2.model');
    else:
        print("Controller Failed, Trying Other Solver:")
        apm_option(s,c,'nlc.solver',nondefault);
        #solve
        output = apm(s,c,'solve');
        d = apm_sol(s,c)
        if (apm_tag(s,c,'nlc.appstatus')==1):
            F = apm_tag(s,c,'F.newval');
        else:
            print("Second Solver Failed")
            apm_get(s,c,'infeasibilities.txt')

    # apm_meas(s,a,'F',F)
    # solver_output = apm(s,a,'solve')

    #Output MV new value
    # if (apm_tag(s,a,'nlc.appstatus')==1):
    #     pass
    # else:
    #     print "Warning: Simulator Failed to Converge"
    #     apm_get(s,a,'infeasibilities.txt')

    th1 = apm_tag(s,c,'th1.meas')
    th2 = apm_tag(s,c,'th2.meas')
    x1 = apm_tag(s,c,'x1.meas')
    ojth1 = apm_tag(s,c,'ojth1.meas')
    ojth2 = apm_tag(s,c,'ojth2.meas')
    F = apm_tag(s,c,'F.newval')

    # p1 = th1-th1_c
    # p2 = th2-th2_c


    # th1 = wrap(th1)
    # th2 = wrap(th2)

    oj = apm_tag(s,c,'nlc.objfcnval')

    print('{0:2f} {1:2f} {2:2f} {3:2f} {4:2f} {5:2f}'.format(time,F,th1,th2,x1,oj))
    # print('{0:2f} {1:2f} {2:2f} {3:2f} {4:2f} '.format(time,th1,th2,F,oj))

    time = time+dt

    th1_tracker = np.append(th1_tracker,th1)
    th2_tracker = np.append(th2_tracker,th2)
    x1_tracker = np.append(x1_tracker,x1)
    oj_tracker = np.append(oj_tracker,oj)
    F_tracker = np.append(F_tracker,F)

    ojth1_tracker = np.append(ojth1_tracker,ojth1)
    ojth2_tracker = np.append(ojth2_tracker,ojth2)
    time_tracker = np.append(time_tracker,time)

    if isim == 1:
        apm_web(s,a)
        apm_web(s,c)


print("Done")
# plot results
import matplotlib.pyplot as plt


plt.figure()
plt.suptitle('Double Inverted Pendulum')

plt.subplot(311)
plt.xlabel('time (s)')
plt.ylabel('Force (N)')
plt.plot(time_tracker,F_tracker,'-r')

plt.subplot(312)
plt.plot(time_tracker,th1_tracker,'-r')
plt.plot(time_tracker,th2_tracker,'-b')
plt.plot(time_tracker,np.ones(len(time_tracker))*np.pi,'-k')
plt.legend(['th1','th2','target'],loc = 'lower right')
plt.xlabel('time (s)')
plt.ylabel('Angle (rad)')

plt.subplot(313)
plt.plot(time_tracker,x1_tracker,'-r')
plt.plot(time_tracker,np.ones(len(time_tracker))*0,'-k')
plt.legend(['x1','target'],loc = 'lower right')
plt.xlabel('time (s)')
plt.ylabel('x1 ')

# plt.subplot(224)
# plt.plot(time_tracker,oj_tracker,'-r')
# plt.xlabel('time (s)')
# plt.ylabel('obj')

plt.show()
