from apm import *
import numpy as np
import random
from mpl_toolkits.mplot3d import axes3d
from matplotlib import cm

def init_mhe(s,a):
    apm(s,a,'clear all')
    # load model and data files
    apm_load(s,a,'mhe_dip.apm')
    csv_load(s,a,'mhe.csv')
    # classify variables
    apm_info(s,a,'FV','m1')
    apm_info(s,a,'FV','m2')
    apm_info(s,a,'MV','F')
    apm_info(s,a,'SV','th1')
    apm_info(s,a,'SV','th2')
    apm_info(s,a,'CV','x1')
    # options
    apm_option(s,a,'nlc.imode',5) # 5 = MHE
    apm_option(s,a,'nlc.ev_type',2) # 1 = l1-norm, 2 = sq_error
    apm_option(s,a,'nlc.nodes',3) # 3 = collocation nodes
    apm_option(s,a,'nlc.solver',1) # 1 = APOPT
    apm_option(s,a,'nlc.max_iter',100) # 3 = APOPT
    # apm_option(s,a,'nlc.wmeas',0)
    # apm_option(s,a,'nlc.wmodel',20)
    apm_option(s,a,'nlc.sensitivity',1)

    # FV tuning
    apm_option(s,a,'m1.status',1) # estimate this parameter
    apm_option(s,a,'m1.fstatus',0) # no measurement (feedback status)
    apm_option(s,a,'m1.lower',1) # lower bound
    apm_option(s,a,'m1.upper',10) # upper bound
    # FV tuning
    apm_option(s,a,'m2.status',1) # estimate this parameter
    apm_option(s,a,'m2.fstatus',0) # no measurement (feedback status)
    apm_option(s,a,'m2.lower',1) # lower bound
    apm_option(s,a,'m2.upper',10) # upper bound
    # MV tuning
    apm_option(s,a,'F.status',0) # don't estimate this parameter
    apm_option(s,a,'F.fstatus',1) # measurement available (feedback status)
    # CV tuning
    apm_option(s,a,'x1.status',1) # estimate this parameter
    apm_option(s,a,'x1.fstatus',1) # measurement available (feedback status)
    apm_option(s,a,'x1.meas_gap',0.1) # measurement deadband gap

    msg = 'MHE Initialized'
    return msg

def init_sim(s,a):
    apm(s,a,'clear all')
    # load model and data files
    apm_load(s,a,'sim_dip.apm')
    csv_load(s,a,'sim.csv')
    # classify variables
    apm_info(s,a,'FV','m1')
    apm_info(s,a,'FV','m2')
    apm_info(s,a,'MV','F')
    apm_info(s,a,'SV','th1')
    apm_info(s,a,'SV','th2')
    apm_info(s,a,'SV','x1')
    # options
    apm_option(s,a,'nlc.imode',4) # 4 = simulation
    apm_option(s,a,'nlc.nodes',3) # 3 = collocation nodes
    apm_option(s,a,'nlc.solver',3) # 3 = IPOPT
    # MV tuning
    apm_option(s,a,'F.fstatus',1) # measurement available (feedback status)
    msg = 'Simulator Initialized'
    return msg

# specify server and application name
s = 'http://byu.apmonitor.com'
# name for the process
a1 = 'sim'
# name for the model / estimator
a2 = 'mhe'

# initialize simulator (plant)
msg = init_sim(s,a1)
print(msg)
# initialize moving horizon estimation (model)
msg = init_mhe(s,a2)
print(msg)

# number of cycles to run
cycles = 80

# step in the Force Applied
F_meas = np.empty(cycles)
F_meas[0:10] = 0
F_meas[10:cycles] = 0
F_meas[20:cycles] = 0
dt = 0.1 # min
time = np.linspace(0,cycles*dt-dt,cycles) # time points

# allocate storage
th1_real = np.empty(cycles)
th2_real = np.empty(cycles)
x1_real = np.empty(cycles)
th1_meas = np.empty(cycles)
th2_meas = np.empty(cycles)
x1_meas = np.empty(cycles)
m1_mhe = np.empty(cycles)
m2_mhe = np.empty(cycles)
th1_mhe = np.empty(cycles)
th2_mhe = np.empty(cycles)
x1_mhe = np.empty(cycles)


for i in range (0,cycles):
    ## Process
    # input F (Force)
    apm_meas(s,a1,'F',F_meas[i])
    # solve process model, 1 time step
    output = apm(s,a1,'solve')
    # retrieve  measurements from the process
    th1_real[i] = apm_tag(s,a1,'th1.model')
    th2_real[i] = apm_tag(s,a1,'th2.model')
    x1_real[i] = apm_tag(s,a1,'x1.model')
    # th1_meas[i] = apm_tag(s,a1,'th1.model')+10*np.pi/180*(2*random.random()-1)
    # th2_meas[i] = apm_tag(s,a1,'th2.model')+10*np.pi/180*(2*random.random()-1)
    x1_meas[i] = apm_tag(s,a1,'x1.model')+.01*(2*random.random()-1)
    # if i > 30:
    #     x1_meas[i] = x1_meas[i-1]
    # if i > 40:
    #     x1_meas[i] = apm_tag(s,a1,'x1.model')+.05*np.pi/180*(2*random.random()-1)

    ## Estimator
    # input process measurements
    apm_meas(s,a2,'F',F_meas[i])
    apm_meas(s,a2,'x1',x1_meas[i])
    # solve process model, 1 time step
    output = apm(s,a2,'solve')
     # check if successful
    if (apm_tag(s,a2,'nlc.appstatus')==1):
        # retrieve solution
        m1_mhe[i] = apm_tag(s,a2,'m1.newval')
        m2_mhe[i] = apm_tag(s,a2,'m2.newval')
        th1_mhe[i] = apm_tag(s,a2,'th1.model')
        th2_mhe[i] = apm_tag(s,a2,'th2.model')
        x1_mhe[i] = apm_tag(s,a2,'x1.model')
    else:
        # display failed run
        print(output)
        # failed solution
        m1_mhe[i] = 0
        m2_mhe[i] = 0
        th1_mhe[i] = 0
        th2_mhe[i] = 0
        x1_mhe[i] = 0

    print('MHE results: th1 (estimated)=' + str(th1_mhe[i]) + \
        ' th2 (estimated)=' + str(th2_mhe[i]) + \
        ' m1 (estimated)=' + str(m1_mhe[i]) + \
        ' m1 (actual)=2.75'+\
        ' m2 (estimated)=' + str(m2_mhe[i]) + \
        ' m2 (actual)=2.75')

    # open web-viewer on first cycle
    if i==1:
        apm_web(s,a2)

#For sensitivity plot
# apm_option(s,a2,'m1.wmeas',10)
# apm_option(s,a2,'m2.wmeas',10)
# apm_option(s,a2,'m2.wmodel',0)
# apm_option(s,a2,'m2.wmodel',0)

# m1s = np.linspace(2.5,4,100)
# m2s = np.linspace(2.5,4,100)
# obj1 = np.zeros(len(m1s))
# obj2 = np.zeros(len(m2s))

# apm_meas(s,a2,'m1',m1_mhe[-1])
# for i in range(len(m1s)):
#     apm_meas(s,a2,'m2',m2s[i])
#     output = apm(s,a2,'solve')
#     if (apm_tag(s,a2,'nlc.appstatus')==1):
#         obj1[i] = apm_tag(s,a2,'nlc.objfcnval')
#     else:
#         print "solver failed to converge."
# apm_meas(s,a2,'m2',m2_mhe[-1])
# for i in range(len(m1s)):
#     apm_meas(s,a2,'m1',m1s[i])
#     output = apm(s,a2,'solve')
#     if (apm_tag(s,a2,'nlc.appstatus')==1):
#         obj2[i] = apm_tag(s,a2,'nlc.objfcnval')
#     else:
#         print "solver failed to converge."


# plot results
import matplotlib.pyplot as plt
plt.figure(1)
plt.suptitle('Moving Horizon Estimation')
# plt.subplot(511)
# plt.plot(time,F_meas,'k-',linewidth=2)
# plt.ylabel('Force (N)')
# plt.legend('Force')

plt.subplot(311)
plt.plot([0,time[-1]],[2.75,2.75],'k--')
plt.plot(time,m1_mhe,'b:',linewidth=2)
plt.plot(time,m2_mhe,'r:',linewidth=2)
plt.axis([0,time[-1],0,10])
plt.ylabel('m2')
plt.legend(['Actual mass','Predicted m1','Predicted m2'])

plt.subplot(312)
plt.plot(time,x1_real,'r-')
plt.plot(time,x1_meas,'go')
plt.plot(time,x1_mhe,'k-',linewidth=2)
plt.ylabel('x1 (m)')
plt.legend(['Real Process x1(m)','Measured x1(m)','Predicted x1(m1)'])

plt.subplot(313)
plt.plot(time,th1_real,'r-')
plt.plot(time,th2_real,'k-')
# plt.plot(time,th1_meas,'go')
plt.plot(time,th1_mhe,'r--',linewidth=2)
plt.plot(time,th2_mhe,'k--',linewidth=2)
plt.ylabel('thetas (rad)')
plt.legend(['Real Process th1','Real Process th2','Predicted th1','Predicted th2'])

# plt.subplot(515)
# plt.plot(time,th2_real,'r-')
# # plt.plot(time,th2_meas,'go')
# plt.plot(time,th2_mhe,'k-',linewidth=2)
# plt.ylabel('th2 (rad)')
# plt.legend(['Real Process th2','Predicted th2'])

# fig = plt.figure(2)
# plt.plot(m1s,obj1,'r-')
# plt.plot(m2s,obj2,'b-')
# print obj1
# print obj2
# plt.xlabel('m(kg)')
# plt.ylabel('Objective Value')
# plt.legend(['m1','m2'])
# plt.title('Objective Function at Terminal Point')
plt.show()
